/**MACRO PROGRAMS FOR All Cause READMISSION SAS PACK Updated 08.20.18 ***/

%MACRO RETRIEVE_HX(INDEXFILE,  OUT_DIAG);

/* IDENTIFYING ADMISSIONS THAT BELONG TO A TRANSFER BUNDLE AND KEEPING
    ONLY ADMISSIONS BEFORE THE LAST ONE OF A TRANSFER BUNDLE */

Proc SQL;
Create table MAXCASE as
Select bid_mpr_3, HISTORY_CASE, count(bid_mpr_3) as maxcase
From &INDEXFILE
Group by bid_mpr_3, history_case;

Create table bundle as
Select a.bid_mpr_3, a.caseid, a.history_case, b.maxcase
From &INDEXFILE (rename=(case=caseid)) as a, maxcase as b
Where a.bid_mpr_3=b.bid_mpr_3 and a.history_case=b.history_case and b.maxcase > 1;
Quit;

DATA BUNDLE;
SET BUNDLE;
bid_mpr_3_HXCASE=strip(bid_mpr_3)||'_'||strip(put(HISTORY_CASE,3.));
RUN;

PROC SORT DATA=BUNDLE;
BY bid_mpr_3_HXCASE CASEID;
RUN;

DATA BUNDLE;
SET BUNDLE;
BY bid_mpr_3_HXCASE;
IF LAST.bid_mpr_3_HXCASE THEN DELETE;
RUN;

PROC SORT DATA=BUNDLE;
BY bid_mpr_3 CASEID;
RUN;

PROC SORT DATA=&INDEXFILE out=sorted_indexfile;
BY bid_mpr_3 CASE;
RUN;

/* add e codes from index - jng 2012 */
DATA &OUT_DIAG;
MERGE BUNDLE (IN=A RENAME=(HISTORY_CASE=CASE) DROP=MAXCASE bid_mpr_3_HXCASE)
    sorted_INDEXFILE (KEEP=bid_mpr_3 CASE ADMIT DISCH DIAG1-DIAG25 /*DVRSND01-DVRSND25*/ CLM_DGNS_PRCDR_ICD_IND
    EDGSCD01-EDGSCD12 /*EVRSCD01-EVRSCD12*/ YEAR  /* changed 1/24/11 zq*/
    RENAME=(CASE=CASEID ADMIT=FDATE DISCH=TDATE));
BY bid_mpr_3 CASEID;
IF A;
diag26 = EDGSCD01; diag27 = EDGSCD02; diag28 = EDGSCD03; diag29 = EDGSCD04;
diag30 = EDGSCD05; diag31 = EDGSCD06; diag32 = EDGSCD07; diag33 = EDGSCD08;
diag34 = EDGSCD09; diag35 = EDGSCD10; diag36 = EDGSCD11; diag37 = EDGSCD12;

attrib diag length=$7.;
* attrib DVRSND length=$1.;
attrib VRSN length=$1.;

ARRAY ICD(1:37) $ DIAG1-DIAG37;
* ARRAY ICDVRS(1:37) $ DVRSND01-DVRSND37;

DO I=1 TO 37;
    IF I=1 THEN DO;
    SOURCE='0.0.1.0';
    DIAG=ICD(I);
    VRSN=CLM_DGNS_PRCDR_ICD_IND;
    OUTPUT;
    END;
    ELSE DO;
    SOURCE='0.0.2.0';
    DIAG=ICD(I);
    VRSN=CLM_DGNS_PRCDR_ICD_IND;
    OUTPUT;
    END;
END;
KEEP bid_mpr_3 CASE DIAG VRSN FDATE TDATE SOURCE YEAR;
RUN;

DATA &OUT_DIAG;
SET &OUT_DIAG;
    IF DIAG IN ('', ' ') THEN DELETE;
RUN;


%MEND RETRIEVE_HX;

%macro ACR_model_variables();


Attrib HxInfection length=8. label='Severe Infection (CC 1, 3-6)';
Attrib OtherInfectious length=8. label='Other infectious disease & pneumonias (CC 7, 114-116)';
Attrib MetaCancer length=8. label='Metastatic cancer/acute leukemia (CC 8)';
Attrib SevereCancer length=8. label='Severe Cancer (CC 9, 10)';
Attrib OtherCancer length=8. label='Other Cancers (CC 11, 12, 13, 14)';
Attrib Diabetes length=8. label='Diabetes mellitus (CC 17-19, 122, 123)';
Attrib Malnutrition length=8. label='Protein-calorie malnutrition (CC 21)';
Attrib LiverDisease length=8. label='End-stage liver disease (CC 27, 28)';
Attrib Hematological length=8. label='Severe Hematological Disorders (CC 46)';
Attrib Alcohol length=8. label='Drug and alcohol disorders (CC 54, 55)';
Attrib Psychological length=8. label='Psychiatric comorbidity (CC 57, 58, 59, 61, 63) ';
Attrib MotorDisfunction length=8. label='Hemiplegia, paraplegia, paralysis, functional disability (CC 70, 71, 73, 74, 103, 104, 189, 190)';
Attrib Seizure length=8. label='Seizure disorders and convulsions (CC 79)';
Attrib CHF length=8. label='CHF (CC 85) ';
Attrib CADCVD length=8. label='Coronary atherosclerosis or angina, cerebrovascular disease (CC 86-89, 102, 105-109)';
Attrib Arrhythmias length=8. label='Specified arrhythmias (CC 96, 97)';
Attrib COPD length=8. label='Coronary obstructive pulmonary disease (COPD) (CC 111) ';
Attrib LungDisorder length=8. label='Fibrosis of lung or other chronic lung disorders (CC 112) ';
Attrib OnDialysis length=8. label='Dialysis status (CC 134)';
Attrib Ulcers length=8. label='Decubitus Ulcer or Chronic Skin Ulcer (CC 157-161) ';
Attrib Septicemia length=8. label='Septicemia/shock (CC 2)';
Attrib MetabolicDisoder length=8. label='Disorders of fluid, electrolyte, acid-base (CC 23, 24)';
Attrib IronDeficiency length=8. label='Iron deficiency or Other Unspecified Anemias and Blood Disease (CC 49)';
Attrib CardioRespiratory length=8. label='Cardio-respiratory failure and shock (CC 84), plus ICD-10-CM codes R09.01 and R09.02';
Attrib RenalFailure length=8. label='Acute renal failure (CC 135-140)';
Attrib PancreaticDisease length=8. label='Pancreatic disease(CC 34, 36)';
Attrib Arthritis length=8. label='Rheumatoid arthritis and inflammatory connective tissue disease (CC 40) ';
Attrib RespiratorDependence length=8. label='Respirator dependence/tracheostomy status (CC 82) ';
Attrib Transplants length=8. label='Transplants (CC 132, 186)';
Attrib Coagulopathy length=8. label='Coagulation defects and other specified hematological disorders (CC 48)';
Attrib HipFracture length=8. label='Hip fracture/dislocation (CC 170)';

If CC1 or CC3 or CC4 or CC5 or CC6 Then HxInfection=1;
    Else HxInfection=0;
If CC7 or CC114 or CC115 or CC116 Then OtherInfectious=1;
    Else OtherInfectious=0;
If CC8 Then MetaCancer=1;
    Else MetaCancer=0;
If CC9 or CC10 Then SevereCancer=1;
    Else SevereCancer=0;
If CC11 or CC12 or CC13 or CC14 Then OtherCancer=1;
    Else OtherCancer=0;
If CC17 or CC18 or CC19 or CC122 or CC123 Then Diabetes=1;
    Else Diabetes=0;
If CC21 Then Malnutrition=1;
    Else Malnutrition=0;
If CC27 or CC28 Then LiverDisease=1;
    Else LiverDisease=0;
If CC46 Then Hematological=1;
    Else Hematological=0;
If CC54 or CC55 Then Alcohol=1;
    Else Alcohol=0;
If CC57 or CC58 or CC59 or CC61 or CC63 Then Psychological=1;
    Else Psychological=0;
If CC70 or CC71 or CC73 or CC74 or CC103 or CC104 or CC189 or CC190 Then MotorDisfunction=1;
    Else MotorDisfunction=0;
If CC79 Then Seizure=1;
    Else Seizure=0;
If CC85 Then CHF=1;
    Else CHF=0;
If CC86 or CC87 or CC88 or CC89 or CC102 or CC105 or CC106 or CC107 or CC108 or CC109 Then CADCVD=1;
    Else CADCVD=0;
If CC96 or CC97 Then Arrhythmias=1;
    Else Arrhythmias=0;
If CC111 Then COPD=1;
    Else COPD=0;
If CC112 Then LungDisorder=1;
    Else LungDisorder=0;
If CC134 Then OnDialysis=1;
    Else OnDialysis=0;
If CC157 or CC158 or CC159 or CC160 or CC161 Then Ulcers=1;
    Else Ulcers=0;
If CC2 Then Septicemia=1;
    Else Septicemia=0;
If CC23 or CC24 Then MetabolicDisoder=1;
    Else MetabolicDisoder=0;
If CC49 Then IronDeficiency=1;
    Else IronDeficiency=0;
If CC84 Then CardioRespiratory=1;
    Else CardioRespiratory=0;
If CC135 or CC136 or CC137 or CC138 or CC139 or CC140 Then RenalFailure=1;
    Else RenalFailure=0;
If CC34 or CC36 Then PancreaticDisease=1;
    Else PancreaticDisease=0;
If CC40 Then Arthritis=1;
    Else Arthritis=0;
If CC82 Then RespiratorDependence=1;
    Else RespiratorDependence=0;
If CC132 or CC186 Then Transplants=1;
    Else Transplants=0;
If CC48 Then Coagulopathy=1;
    Else Coagulopathy=0;
If CC170 Then HipFracture=1;
    Else HipFracture=0;

%mend ACR_model_variables;



%macro ACR_model_Condition_Indicator();

ATTRIB CONDITION LENGTH=$4.;
condition = addxg;

/* medicine */
IF COHORT = 'MEDICINE' THEN DO;
    IF ADDXGnum IN (&med_lfaddxg) THEN CONDITION='000';
    ELSE CONDITION=ADDXG;
END;

/* surgical */

ELSE IF COHORT = 'SURGICAL' THEN DO;
    IF ADDXGnum IN (&surg_lfaddxg) THEN CONDITION='000';
    ELSE CONDITION=ADDXG;
END;

/* cardiosrespiratory */

ELSE IF COHORT = 'CARDIORESPIRATORY' THEN DO;
    IF ADDXGnum IN (&cardio_lfaddxg) THEN CONDITION='000';
    ELSE CONDITION=ADDXG;
END;

/* cv */

ELSE IF COHORT = 'CV' THEN DO;
    IF ADDXGnum IN (&CV_lfaddxg) THEN CONDITION='000';
    ELSE CONDITION=ADDXG;
END;

/* neurology */

ELSE IF COHORT ='NEUROLOGY' THEN DO;
    IF ADDXGnum IN (&neuro_lfaddxg) THEN CONDITION='000';
    ELSE CONDITION=ADDXG;
END;

%mend ACR_model_Condition_Indicator;



%MACRO HGLM_CONDITION_TIN_MOD_Z(INFILE, CONDITION);

proc sort data=&infile out=work.zinput; by tin_assigned condition; run;
proc sort data=work.zinput out=work.num_tin_id (keep=tin_assigned) nodupkey; by tin_assigned; run;
data work.num_tin_id;
  set work.num_tin_id;
  num_tin_id=_n_;
run;
data work.zinput;
  merge work.zinput (in=a) work.num_tin_id;
  by tin_assigned;
  if a;
run;

PROC GLIMMIX DATA=work.zinput (WHERE=(COHORT="&CONDITION")) NOCLPRINT MAXLMMUPDATE=1000;
TITLE "ALL CAUSE READMISSION: &CONDITION COHORT";
class CONDITION;
MODEL RADM30=CONDITION &MODEL_VAR/D=B LINK=LOGIT SOLUTION ddfm=residual;
XBETA=_XBETA_;
LINP=_LINP_;
RANDOM INTERCEPT/SUBJECT=num_tin_id;
RANDOM _RESIDUAL_;
OUTPUT OUT=RADM30
                                PRED(BLUP ILINK)=PREDPROB PRED(NOBLUP ILINK)=EXPPROB;
ID XBETA LINP TIN_ASSIGNED bid_mpr_3 CASE RADM30 radm30p;
NLOPTIONS tech=nmsimp ;
run;

PROC SQL NOPRINT;
SELECT MEAN(RADM30) INTO: YBAR FROM RADM30;
QUIT;

PROC SQL;
CREATE TABLE &CONDITION._RSRR AS
SELECT DISTINCT TIN_ASSIGNED, MEAN(RADM30) AS OBS,
                sum(radm30) as radm, /* added 5/1, z1 */
                sum(radm30p) as radmp, /* added 5/1, z1 */
                MEAN(PREDPROB) AS PRED,
                MEAN(EXPPROB) AS EXP,
                (CALCULATED PRED)/(CALCULATED EXP) AS SRR,
                (CALCULATED SRR)*&YBAR AS RSRR,
                COUNT(TIN_ASSIGNED) AS VOLUME
FROM RADM30
GROUP BY TIN_ASSIGNED;
QUIT;

PROC SORT DATA=&CONDITION._RSRR;
BY TIN_ASSIGNED;

proc datasets lib=work nolist;
  delete zinput num_tin_id;
run; quit;

%MEND HGLM_CONDITION_TIN_MOD_Z;



%MACRO CMS_HCC_GET(INDSN, OUTDSN, prefix); /* ZQ: add prefix 2/7/09 */
 /* AP/PS - Changed ICD9 to ICD since will be ICD9 and ICD10 */
 /* AP/PS - create dataset with ICD/HCC crosswalk*/
 DATA TEMP0;
    SET &V22_ICD_HCC;
    if icd_ind = '9' then do;
        IF DX_ICD in ('79901', '79902') then hcc = '84';
        IF DX_ICD IN ('40403','40413','40493') THEN hcc = '85';
        end;
    else if icd_ind = '0' then do;
        IF DX_ICD in ('R0902', 'R0901') then HCC='84';
        IF DX_ICD in ('I132') then HCC = '85';
        End;    
 run;

 PROC SQL;
  CREATE TABLE TEMP11 AS
  SELECT IND.*, T0.HCC AS ADDXG
  FROM &INDSN IND
  LEFT OUTER JOIN
  TEMP0       T0
  ON T0.DX_ICD   = IND.ICD
  AND T0.ICD_IND =IND.vrsn
  ;
  QUIT;

 DATA TEMP1;
  SET TEMP11;
   length nhic $18.;
    nhic=strip(bid_mpr_3) || '_' || strip(put(case,5.));
   KEEP bid_mpr_3 CASE ADDXG SOURCE nhic ICD vrsn AGE SEX;
  RUN;

  PROC SORT DATA=TEMP1 NODUP;
    BY nHIC ADDXG ICD;
  RUN;

  /*  Using a format, this step maps each addxg group for a person into a larger;
  *  group denoted by "CC".  The numeric variable IND is set to the value of ;
  *  the character variable CC. If ind is between 1 and 189 then ;
  *  the ind'th element of the array "C" is set to 1; if not it is set to 0 ;
  *  The array has variables CC1 through CC189. The array is retained as each ;
  *  ADDXG record is mapped for a person.  After last record for a person is;
  *  mapped, the macro at the top of the program is run to allow the presence of;
  *  high severity diseases to cancel out low severity versions of the disease. ;
  *  The final vector of 1's and 0's is stored in the variables HCC1 - HCC189.  ;
  *  The record is written to the output dataset and the CCs are reinitialized  ;
  *  the HCCs are the diagnosis groups that are used in the risk adjustment formula;
  */

  DATA &OUTDSN(KEEP=bid_mpr_3 CASE &prefix.CC1-&prefix.CC201 nhic) ERR;
    SET TEMP1;
    by nhic;
    length cc $4.;


   cc=left(addxg);

/* ES - NEW LOGIC TO CONFORM TO 2006 HCC FORMATS 2/23 */
  _ICD_3 = SUBSTR(ICD,1,3);    *first 3 characters from ICD9;
  _ICD_4 = SUBSTR(ICD,1,4);    *first 4 characters from ICD9;


        /* age/sex restrictions */
      SELECT;
        /* males only  */
        WHEN (vrsn="9" AND
              ( '185'<= _ICD_3 <='187'
                 OR _ICD_3 = '257')
                 AND SEX='2')  CC='-1.0';

       WHEN  (vrsn="0" AND
               ( _ICD_3 IN ('C60', 'C61', 'C62', 'C63','E29')
                 OR ICD='E895')
                 AND SEX='2')     CC='-1.0';

       WHEN  (CC='149'
                 AND SEX='2')     CC='-1.0';
   ****************************************;
   /* females only */
         WHEN ( vrsn="9" AND
              ( '179'<=_ICD_3<='184'
                 OR _ICD_3 = '256')
                 AND SEX='1')     CC='-1.0';
         WHEN ( vrsn="0" AND
              ( _ICD_3 IN ('C51', 'C52','C53', 'C54', 'C55', 'C56', 'C57','E28')
                 OR ICD IN ('E8940', 'E8941','N981'))
                 AND SEX='1')     CC='-1.0';
        WHEN (CC IN ('147','148')
                 AND SEX='1')     CC='-1.0';
    /* Infertility, Pregnancy DXGs Restricted to Females
          Between Ages 8 and 59 */
         WHEN (CC IN ('146','150','151','152','153','154','155','156')
                AND (SEX='1'
                OR AGE<8 OR AGE>59))  CC='-1.0';

        /* newborns */
         WHEN(CC IN ('180','181','182','183')
                AND AGE>=2)       CC='-1.0';
         OTHERWISE;
      END; *SELECT;

   /* AP/PS - in model V22 201 CC */
      RETAIN &prefix.CC1-&prefix.CC201 0 ;
*    RETAIN &prefix.CC1-&prefix.CC189 0 ;
*    RETAIN HCC1-HCC189 0 ;

    ATTRIB &prefix.CC1-&prefix.CC201  LENGTH=3.;
    ARRAY C(201)  &prefix.CC1-&prefix.CC201;

*    ATTRIB HCC1-HCC189  LENGTH=3.;
*    ARRAY HCC(189) HCC1-HCC189;

    IF CC NOT IN ('0.0 ',' 0.0','-1.0',' -1.') THEN DO;
      *- to find index for the array for current PHCC -;
      IND = INPUT(CC,8.);
      IF 1<= IND <= 201 THEN C(IND)=1;
      ELSE OUTPUT ERR;
    END;


    IF LAST.nHIC THEN DO;
       OUTPUT &OUTDSN;
      DO I=1 TO 201;
        C(I)=0;
      END;
    END;


      *revision7;
      *revison (nmodel V22) AP/PS;
      *labels for CC133, CC185 and CC198 are missing;
    label
      &prefix.CC1   ="HIV/AIDS                                                           "
      &prefix.CC2   ="Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock  "
      &prefix.CC3   ="Bacterial, Fungal, and Parasitic Central Nervous System Infections "
      &prefix.CC4   ="Viral and Late Effects Central Nervous System Infections           "
      &prefix.CC5   ="Tuberculosis                                                       "
      &prefix.CC6   ="Opportunistic Infections                                           "
      &prefix.CC7   ="Other Infectious Diseases                                          "
      &prefix.CC8   ="Metastatic Cancer and Acute Leukemia                               "
      &prefix.CC9   ="Lung and Other Severe Cancers                                      "
      &prefix.CC10  ="Lymphoma and Other Cancers                                         "
      &prefix.CC11  ="Colorectal, Bladder, and Other Cancers                             "
      &prefix.CC12  ="Breast, Prostate, and Other Cancers and Tumors                     "
      &prefix.CC13  ="Other Respiratory and Heart Neoplasms                              "
      &prefix.CC14  ="Other Digestive and Urinary Neoplasms                              "
      &prefix.CC15  ="Other Neoplasms                                                    "
      &prefix.CC16  ="Benign Neoplasms of Skin, Breast, Eye                              "
      &prefix.CC17  ="Diabetes with Acute Complications                                  "
      &prefix.CC18  ="Diabetes with Chronic Complications                                "
      &prefix.CC19  ="Diabetes without Complication                                      "
      &prefix.CC20  ="Major Eye Infections/Inflammations                                 "
      &prefix.CC21  ="Protein-Calorie Malnutrition                                       "
      &prefix.CC22  ="Morbid Obesity                                                     "
      &prefix.CC23  ="Other Significant Endocrine and Metabolic Disorders                "
      &prefix.CC24  ="Disorders of Fluid/Electrolyte/Acid-Base Balance                   "
      &prefix.CC25  ="Disorders of Lipoid Metabolism                                     "
      &prefix.CC26  ="Other Endocrine/Metabolic/Nutritional Disorders                    "
      &prefix.CC27  ="End-Stage Liver Disease                                            "
      &prefix.CC28  ="Cirrhosis of Liver                                                 "
      &prefix.CC29  ="Chronic Hepatitis                                                  "
      &prefix.CC30  ="Acute Liver Failure/Disease                                        "
      &prefix.CC31  ="Other Hepatitis and Liver Disease                                  "
      &prefix.CC32  ="Gallbladder and Biliary Tract Disorders                            "
      &prefix.CC33  ="Intestinal Obstruction/Perforation                                 "
      &prefix.CC34  ="Chronic Pancreatitis                                               "
      &prefix.CC35  ="Inflammatory Bowel Disease                                         "
      &prefix.CC36  ="Peptic Ulcer, Hemorrhage, Other Specified Gastrointestinal Disorders"
      &prefix.CC37  ="Appendicitis                                                       "
      &prefix.CC38  ="Other Gastrointestinal Disorders                                   "
      &prefix.CC39  ="Bone/Joint/Muscle Infections/Necrosis                              "
      &prefix.CC40  ="Rheumatoid Arthritis and Inflammatory Connective Tissue Disease    "
      &prefix.CC41  ="Disorders of the Vertebrae and Spinal Discs                        "
      &prefix.CC42  ="Osteoarthritis of Hip or Knee                                      "
      &prefix.CC43  ="Osteoporosis and Other Bone/Cartilage Disorders                    "
      &prefix.CC44  ="Congenital/Developmental Skeletal and Connective Tissue Disorders  "
      &prefix.CC45  ="Other Musculoskeletal and Connective Tissue Disorders              "
      &prefix.CC46  ="Severe Hematological Disorders                                     "
      &prefix.CC47  ="Disorders of Immunity                                              "
      &prefix.CC48  ="Coagulation Defects and Other Specified Hematological Disorders    "
      &prefix.CC49  ="Iron Deficiency and Other/Unspecified Anemias and Blood Disease    "
      &prefix.CC50  ="Delirium and Encephalopathy                                        "
      &prefix.CC51  ="Dementia With Complications                                        "
      &prefix.CC52  ="Dementia Without Complication                                      "
      &prefix.CC53  ="Nonpsychotic Organic Brain Syndromes/Conditions                    "
      &prefix.CC54  ="Drug/Alcohol Psychosis                                             "
      &prefix.CC55  ="Drug/Alcohol Dependence                                            "
      &prefix.CC56  ="Drug/Alcohol Abuse, Without Dependence                             "
      &prefix.CC57  ="Schizophrenia                                                      "
      &prefix.CC58  ="Major Depressive, Bipolar, and Paranoid Disorders                  "
      &prefix.CC59  ="Reactive and Unspecified Psychosis                                 "
      &prefix.CC60  ="Personality Disorders                                              "
      &prefix.CC61  ="Depression                                                         "
      &prefix.CC62  ="Anxiety Disorders                                                  "
      &prefix.CC63  ="Other Psychiatric Disorders                                        "
      &prefix.CC64  ="Profound Intellectual Disability/Developmental Disorder            "
      &prefix.CC65  ="Severe Intellectual Disability/Developmental Disorder              "
      &prefix.CC66  ="Moderate Intellectual Disability/Developmental Disorder            "
      &prefix.CC67  ="Mild Intellectual Disability, Autism, Down Syndrome                "
      &prefix.CC68  ="Other Developmental Disorders                                      "
      &prefix.CC69  ="Attention Deficit Disorder                                         "
      &prefix.CC70  ="Quadriplegia                                                       "
      &prefix.CC71  ="Paraplegia                                                         "
      &prefix.CC72  ="Spinal Cord Disorders/Injuries                                     "
      &prefix.CC73  ="Amyotrophic Lateral Sclerosis and Other Motor Neuron Disease       "
      &prefix.CC74  ="Cerebral Palsy                                                     "
      &prefix.CC75  ="Myasthenia Gravis/Myoneural Disorders and Guillain-Barre Syndrome/Inflammatory and Toxic Neuropathy"
      &prefix.CC76  ="Muscular Dystrophy                                                 "
      &prefix.CC77  ="Multiple Sclerosis                                                 "
      &prefix.CC78  ="Parkinson's and Huntington's Diseases                              "
      &prefix.CC79  ="Seizure Disorders and Convulsions                                  "
      &prefix.CC80  ="Coma, Brain Compression/Anoxic Damage                              "
      &prefix.CC81  ="Polyneuropathy, Mononeuropathy, and Other Neurological Conditions/Injuries"
      &prefix.CC82  ="Respirator Dependence/Tracheostomy Status                          "
      &prefix.CC83  ="Respiratory Arrest                                                 "
      &prefix.CC84  ="Cardio-Respiratory Failure and Shock                               "
      &prefix.CC85  ="Congestive Heart Failure                                           "
      &prefix.CC86  ="Acute Myocardial Infarction                                        "
      &prefix.CC87  ="Unstable Angina and Other Acute Ischemic Heart Disease             "
      &prefix.CC88  ="Angina Pectoris                                                    "
      &prefix.CC89  ="Coronary Atherosclerosis/Other Chronic Ischemic Heart Disease      "
      &prefix.CC90  ="Heart Infection/Inflammation, Except Rheumatic                     "
      &prefix.CC91  ="Valvular and Rheumatic Heart Disease                               "
      &prefix.CC92  ="Major Congenital Cardiac/Circulatory Defect                        "
      &prefix.CC93  ="Other Congenital Heart/Circulatory Disease                         "
      &prefix.CC94  ="Hypertensive Heart Disease                                         "
      &prefix.CC95  ="Hypertension                                                       "
      &prefix.CC96  ="Specified Heart Arrhythmias                                        "
      &prefix.CC97  ="Other Heart Rhythm and Conduction Disorders                        "
      &prefix.CC98  ="Other and Unspecified Heart Disease                                "
      &prefix.CC99  ="Cerebral Hemorrhage                                                "
      &prefix.CC100 ="Ischemic or Unspecified Stroke                                     "
      &prefix.CC101 ="Precerebral Arterial Occlusion and Transient Cerebral Ischemia     "
      &prefix.CC102 ="Cerebrovascular Atherosclerosis, Aneurysm, and Other Disease       "
      &prefix.CC103 ="Hemiplegia/Hemiparesis                                             "
      &prefix.CC104 ="Monoplegia, Other Paralytic Syndromes                              "
      &prefix.CC105 ="Late Effects of Cerebrovascular Disease, Except Paralysis          "
      &prefix.CC106 ="Atherosclerosis of the Extremities with Ulceration or Gangrene     "
      &prefix.CC107 ="Vascular Disease with Complications                                "
      &prefix.CC108 ="Vascular Disease                                                   "
      &prefix.CC109 ="Other Circulatory Disease                                          "
      &prefix.CC110 ="Cystic Fibrosis                                                    "
      &prefix.CC111 ="Chronic Obstructive Pulmonary Disease                              "
      &prefix.CC112 ="Fibrosis of Lung and Other Chronic Lung Disorders                  "
      &prefix.CC113 ="Asthma                                                             "
      &prefix.CC114 ="Aspiration and Specified Bacterial Pneumonias                      "
      &prefix.CC115 ="Pneumococcal Pneumonia, Empyema, Lung Abscess                      "
      &prefix.CC116 ="Viral and Unspecified Pneumonia, Pleurisy                          "
      &prefix.CC117 ="Pleural Effusion/Pneumothorax                                      "
      &prefix.CC118 ="Other Respiratory Disorders                                        "
      &prefix.CC119 ="Legally Blind                                                      "
      &prefix.CC120 ="Major Eye Infections/Inflammations                                 "
      &prefix.CC121 ="Retinal Detachment                                                 "
      &prefix.CC122 ="Proliferative Diabetic Retinopathy and Vitreous Hemorrhage         "
      &prefix.CC123 ="Diabetic and Other Vascular Retinopathies                          "
      &prefix.CC124 ="Exudative Macular Degeneration                                     "
      &prefix.CC125 ="Other Retinal Disorders                                            "
      &prefix.CC126 ="Glaucoma                                                           "
      &prefix.CC127 ="Cataract                                                           "
      &prefix.CC128 ="Other Eye Disorders                                                "
      &prefix.CC129 ="Significant Ear, Nose, and Throat Disorders                        "
      &prefix.CC130 ="Hearing Loss                                                       "
      &prefix.CC131 ="Other Ear, Nose, Throat, and Mouth Disorders                       "
      &prefix.CC132 ="Kidney Transplant Status                                           "
    /* AP/PS - label for this HCC is absent  */
    /*  &prefix.CC133 ="End Stage Renal Disease                                          "*/
      &prefix.CC134 ="Dialysis Status                                                    "
      &prefix.CC135 ="Acute Renal Failure                                                "
      &prefix.CC136 ="Chronic Kidney Disease, Stage 5                                    "
      &prefix.CC137 ="Chronic Kidney Disease, Severe, Stage 4                            "
      &prefix.CC138 ="Chronic Kidney Disease, Moderate, Stage 3                          "
      &prefix.CC139 ="Chronic Kidney Disease, Mild or Unspecified, Stages 1-2 or Unspecified"
      &prefix.CC140 ="Unspecified Renal Failure                                          "
      &prefix.CC141 ="Nephritis                                                          "
      &prefix.CC142 ="Urinary Obstruction and Retention                                  "
      &prefix.CC143 ="Urinary Incontinence                                               "
      &prefix.CC144 ="Urinary Tract Infection                                            "
      &prefix.CC145 ="Other Urinary Tract Disorders                                      "
      &prefix.CC146 ="Female Infertility                                                 "
      &prefix.CC147 ="Pelvic Inflammatory Disease and Other Specified Female Genital Disorders"
      &prefix.CC148 ="Other Female Genital Disorders                                     "
      &prefix.CC149 ="Male Genital Disorders                                             "
      &prefix.CC150 ="Ectopic and Molar Pregnancy                                        "
      &prefix.CC151 ="Miscarriage/Terminated Pregnancy                                   "
      &prefix.CC152 ="Completed Pregnancy With Major Complications                       "
      &prefix.CC153 ="Completed Pregnancy With Complications                             "
      &prefix.CC154 ="Completed Pregnancy With No or Minor Complications                 "
      &prefix.CC155 ="Uncompleted Pregnancy With Complications                           "
      &prefix.CC156 ="Uncompleted Pregnancy With No or Minor Complications               "
      &prefix.CC157 ="Pressure Ulcer of Skin with Necrosis Through to Muscle, Tendon, or Bone"
      &prefix.CC158 ="Pressure Ulcer of Skin with Full Thickness Skin Loss               "
      &prefix.CC159 ="Pressure Ulcer of Skin with Partial Thickness Skin Loss            "
      &prefix.CC160 ="Pressure Pre-Ulcer Skin Changes or Unspecified Stage               "
      &prefix.CC161 ="Chronic Ulcer of Skin, Except Pressure                             "
      &prefix.CC162 ="Severe Skin Burn or Condition                                      "
      &prefix.CC163 ="Moderate Skin Burn or Condition                                    "
      &prefix.CC164 ="Cellulitis, Local Skin Infection                                   "
      &prefix.CC165 ="Other Dermatological Disorders                                     "
      &prefix.CC166 ="Severe Head Injury                                                 "
      &prefix.CC167 ="Major Head Injury                                                  "
      &prefix.CC168 ="Concussion or Unspecified Head Injury                              "
      &prefix.CC169 ="Vertebral Fractures without Spinal Cord Injury                     "
      &prefix.CC170 ="Hip Fracture/Dislocation                                           "
      &prefix.CC171 ="Major Fracture, Except of Skull, Vertebrae, or Hip                 "
      &prefix.CC172 ="Internal Injuries                                                  "
      &prefix.CC173 ="Traumatic Amputations and Complications                            "
      &prefix.CC174 ="Other Injuries                                                     "
      &prefix.CC175 ="Poisonings and Allergic and Inflammatory Reactions                 "
      &prefix.CC176 ="Complications of Specified Implanted Device or Graft               "
      &prefix.CC177 ="Other Complications of Medical Care                                "
      &prefix.CC178 ="Major Symptoms, Abnormalities                                      "
      &prefix.CC179 ="Minor Symptoms, Signs, Findings                                    "
      &prefix.CC180 ="Extremely Immature Newborns, Including Birthweight < 1000 Grams    "
      &prefix.CC181 ="Premature Newborns, Including Birthweight 1000-1499 Grams          "
      &prefix.CC182 ="Serious Perinatal Problem Affecting Newborn                        "
      &prefix.CC183 ="Other Perinatal Problems Affecting Newborn                         "
      &prefix.CC184 ="Term or Post-Term Singleton Newborn, Normal or High Birthweight    "
      /* AP/PS - label for this HCC is absent  */
      /*&prefix.CC185 =" Major Organ Transplant (procedure)                              " */
      &prefix.CC186 ="Major Organ Transplant or Replacement Status                       "
      &prefix.CC187 ="Other Organ Transplant Status/Replacement                          "
      &prefix.CC188 ="Artificial Openings for Feeding or Elimination                     "
      &prefix.CC189 ="Amputation Status, Lower Limb/Amputation Complications             "
      &prefix.CC190 ="Amputation Status, Upper Limb                                      "
      &prefix.CC191 ="Post-Surgical States/Aftercare/Elective                            "
      &prefix.CC192 ="Radiation Therapy                                                  "
      &prefix.CC193 ="Chemotherapy                                                       "
      &prefix.CC194 ="Rehabilitation                                                     "
      &prefix.CC195 ="Screening/Observation/Special Exams                                "
      &prefix.CC196 ="History of Disease                                                 "
      &prefix.CC197 ="Supplemental Oxygen                                                "
    /* AP/PS - label for this HCC is absent  */
    /*   &prefix.CC198 ="CPAP/IPPB/Nebulizers                                               " */
      &prefix.CC199 ="Patient Lifts, Power Operated Vehicles, Beds                       "
      &prefix.CC200 ="Wheelchairs, Commodes                                              "
      &prefix.CC201 ="Walkers                                                            ";


  RUN;

%MEND CMS_HCC_GET;


/*--------------------------------------------------------------------------
* Create age, sex and source variables and re-arrange RTI dataset to one
  ICD-9 code per line in the index admission event file;

Yale University
YW 05-2003
----------------------------------------------------------------------------*/;
%MACRO HCCPAI(INDSN, OUTDSN);
  DATA &OUTDSN;
    SET &INDSN;
    AGE=INT((ADMIT-BIRTH)/365.25);
    SEX="" || CSEX;
    SOURCE='0.0.2.0'; /*ZQ: source changed 2/7/09 */
     ARRAY ICDCODE{1:25} $ DIAG1-DIAG25;  /* changed 1/24/11 */
    DO I=2 TO 25;
      ICD=ICDCODE[I];
      vrsn = CLM_DGNS_PRCDR_ICD_IND;
	  if ICD not in ('', ' ') then output;
    END;

    IF ICD='' THEN DELETE;
    KEEP bid_mpr_3 CASE AGE SEX ICD vrsn SOURCE;
  RUN;
%MEND HCCPAI;

/* Revised routine for 2013 hwr reporting, for SAS 9.3
June 25, 2013
*/


***************************************************************;
* PROGRAM NAME: BOOTSTRAP_3b_altmethods.SAS                   *;
* SAS 9.1.3 WIN                                               *;
* ZQ LIN, YALE/YNHH CORE                                      *;
* 3/14/2008 (created for Heart Failure readmission measure)   *;
* 7/2/2008 (updated for AMI & Pneumonia readmission measures, *;
* incorporated changes made by JS from MPR.)                  *;
* 5/1/2012 modified for HWR measure, beta version             *;
* *************************************************************;

options pageno=1 date;
OPTIONS SYMBOLGEN MPRINT;

%MACRO BOOTSTRAP_HOSPITAL_READMISSION(SFILE, TFILE, STARTPOINT, ENDPOINT, SEED);

%LET COHORT1=MEDICINE;
%LET COHORT2=SURGICAL;
%LET COHORT3=CARDIORESPIRATORY;
%LET COHORT4=CV;
%LET COHORT5=NEUROLOGY;


%DO specialty=1 %TO 5;
DATA &TFILE._&&COHORT&specialty;

ATTRIB H_S_ID LENGTH=8.;
ATTRIB tin_assigned LENGTH=$10.;
ATTRIB ITERATION LENGTH=8.;
ATTRIB RADM LENGTH=8.;
ATTRIB SUBID LENGTH=8.;
ATTRIB EXP_R LENGTH=8.;
ATTRIB PRED_R LENGTH=8.;
ATTRIB OBS LENGTH=8.;
ATTRIB VOLUME LENGTH=8.;
ATTRIB SRR LENGTH=8.;

H_S_ID=.;
tin_assigned='';
ITERATION=.;
RADM=.;
SUBID=.;
EXP_R=.;
PRED_R=.;
OBS=.;
VOLUME=.;
SRR=.;
RUN;

%END;

DATA &TFILE._HWR;

ATTRIB tin_assigned LENGTH=$10.;
ATTRIB ITERATION LENGTH=8.;
ATTRIB OBS_HWR LENGTH=8.;
ATTRIB SRR_HWR LENGTH=8.;
ATTRIB RSRR_HWR LENGTH=8.;
ATTRIB VOLUME LENGTH=8.;
ATTRIB READMISSION LENGTH=8.;

tin_assigned='';
ITERATION=.;
OBS_HWR=.;
RSRR_HWR=.;
SRR_HWR=.;
VOLUME=.;
READMISSION=.;

RUN;


PROC SORT DATA=&SFILE;
    BY tin_assigned;
RUN;

PROC SQL NOPRINT;
    CREATE TABLE HOSPITAL AS
    SELECT tin_assigned, COUNT(tin_assigned) AS VOLUME
    FROM &SFILE
    GROUP BY tin_assigned;
QUIT;

***************************************************************************;
* SAMPLE HOSPITAL WITH REPLACEMENT                                        *;
* ONE HOSPITAL MAY BE SAMPLED MORE THAN ONCE                              *;
* TOTLA NUMBER OF HOSPITAL WILL EQUAL TO THE NUMBER OF HOSPITAL IN THE    *;
* ORIGINAL DATASET. FOR HOSPITALS THAT APPEAR MORE THAN ONCE, THEY ARE    *;
* TREATED AS DISTINCT HOSPITAL.                                           *;
* ALL THE PATIENTS WITHIN EACH HOSPITAL ARE INCLUDED.                     *;
***************************************************************************;

%DO BS=&STARTPOINT %TO &ENDPOINT;

/* SAMPLING HOSPITALS */
PROC SURVEYSELECT DATA=HOSPITAL METHOD=URS SAMPRATE=1 OUT=H seed=%eval(&bs + &seed);
RUN;

DATA H2;
    SET H;
    DO I=1 TO NUMBERHITS;
            H_S_ID + 1;
        OUTPUT;
    END;
RUN;

PROC SORT DATA=H2;
    BY tin_assigned;
RUN;


/* CONSTRUCTING PATIENT LEVEL DATA BASED ON HOSPITAL LEVEL DATA FROM THE ABOVE STEP */
/* THE TOTAL SAMPLE SIZE MAY BE DIFFERENT FROM THE ORIGINAL SAMPLE SIZE             */

PROC SQL NOPRINT;
    CREATE TABLE BSHP AS
    SELECT B.H_S_ID, A.* FROM &SFILE AS A INNER JOIN H2 AS B
    ON A.tin_assigned=B.tin_assigned;
QUIT;



*****************************************************************************;
* FITTING HIERARCHICAL MODEL                                                *;
*****************************************************************************;



%DO specialty=1 %TO 5;


/* PARAMETERIZE OPTIMIZATION TECHNIQUE AND OFFER 2 OPTIONS JS 3/19/08 */

PROC GLIMMIX DATA=BSHP (WHERE=(COHORT="&&COHORT&specialty")) NOCLPRINT  MAXLMMUPDATE= &nbrits;
CLASS H_S_ID condition;
ODS OUTPUT SOLUTIONR=SR_&bs._&&COHORT&specialty;
MODEL RADM30=condition &MODEL_VAR    /d=b link=logit solution;
XBETA=_XBETA_;
RANDOM INTERCEPT/SUBJECT=H_S_ID SOLUTION;
*****RANDOM _RESIDUAL_;  * removed 3/2014 JNG;
OUTPUT OUT=PRED_&bs._&&COHORT&specialty PRED(BLUP ILINK)=PREDPROB PRED(NOBLUP ILINK)=EXPPROB;
ID XBETA PSTATE tin_assigned H_S_ID bid_mpr_3 CASE RADM30;
NLOPTIONS TECH=&firstmethod;
run;

* assuming that the one of the methods will converge;
%if %sysfunc(exist(sr_&bs._&&COHORT&specialty)) %then %do;
        data _null_;
            file PRINT;
            put "DEBUG:  iteration # &bs converged with &firstmethod";
        run;
        %end;
    %else %do;
        PROC GLIMMIX DATA=BSHP (WHERE=(COHORT="&&COHORT&specialty")) NOCLPRINT MAXLMMUPDATE= &nbrits;
            CLASS H_S_ID condition;
            ODS OUTPUT SOLUTIONR=SR_&bs._&&COHORT&specialty;
            MODEL RADM30=condition &MODEL_VAR    /d=b link=logit solution;
            XBETA=_XBETA_;
            RANDOM INTERCEPT/SUBJECT=H_S_ID SOLUTION;
*****RANDOM _RESIDUAL_;  * removed 3/2014 JNG;
            OUTPUT OUT=PRED_&bs._&&COHORT&specialty PRED(BLUP ILINK)=PREDPROB PRED(NOBLUP ILINK)=EXPPROB;
            ID XBETA PSTATE tin_assigned H_S_ID bid_mpr_3 CASE RADM30;
            NLOPTIONS TECH=&nextmethod;
        run;
        %if %sysfunc(exist(sr_&bs._&&COHORT&specialty)) %then %do;
            data _null_;
                file PRINT;
                put "DEBUG:  iteration # &bs converged with &nextmethod";
            run;
            %end;
        %else %do;
            data _null_;
                file PRINT;
                put "DEBUG:  iteration # &bs failed to converge";
            run;
            %end;
        %end;

%if %sysfunc(exist(sr_&bs._&&COHORT&specialty)) %then %do;

PROC SORT DATA=PRED_&bs._&&COHORT&specialty;
    BY H_S_ID;
RUN;

DATA RE_&bs._&&COHORT&specialty;
    SET SR_&bs._&&COHORT&specialty (KEEP=SUBJECT ESTIMATE STDERRPRED);
    LENGTH H_S_ID 8.;
    H_S_ID=SUBSTR(SUBJECT, 8);
    multiplier=rannor(&SEED + &bs);
    m_stderr=stderrpred*multiplier;
    DROP SUBJECT;
RUN;

PROC SORT DATA=RE_&bs._&&COHORT&specialty;
    BY H_S_ID;
RUN;

DATA ALL_&bs._&&COHORT&specialty;
    MERGE PRED_&bs._&&COHORT&specialty (IN=A) RE_&bs._&&COHORT&specialty;
    BY H_S_ID;
    IF A;
    LINP=XBETA + ESTIMATE;
    LINP_BS=LINP + m_stderr;
    P_XBETA=EXP(XBETA)/(1 + EXP(XBETA));
    P_LINP=EXP(LINP)/(1 + EXP(LINP));
    P_LINP_BS=EXP(LINP_BS)/(1 + EXP(LINP_BS));
    IF RADM30 ^=. AND P_LINP_BS ^=. AND P_XBETA ^=.;
    KEEP tin_assigned RADM30 P_XBETA P_LINP_BS H_S_ID;
RUN;;

PROC SQL NOPRINT;
    CREATE TABLE BSHP&BS._&&COHORT&specialty AS
    SELECT DISTINCT H_S_ID, tin_assigned,
                &BS AS ITERATION,
                SUM(RADM30) AS RADM, /* CHANGED, ZQ, 4/30*/
                RANNOR(&SEED+ &BS) AS SUBID,
                MEAN(P_XBETA) AS EXP_R,
                MEAN(P_LINP_BS) AS PRED_R,
                MEAN(RADM30) AS OBS,
                COUNT(tin_assigned) AS VOLUME,
                (CALCULATED PRED_R)/(CALCULATED EXP_R) AS SRR
    FROM ALL_&bs._&&COHORT&specialty
    GROUP BY H_S_ID;
QUIT;

PROC SORT DATA=BSHP&BS._&&COHORT&specialty;
BY tin_assigned SUBID;

DATA BSHP&BS._&&COHORT&specialty;
    SET BSHP&BS._&&COHORT&specialty;
    BY tin_assigned;
    IF FIRST.tin_assigned THEN OUTPUT;
RUN;

PROC APPEND BASE=&TFILE._&&COHORT&specialty DATA=BSHP&BS._&&COHORT&specialty FORCE;
RUN;

%end;


proc delete data=SR_&bs._&&COHORT&specialty
                PRED_&bs._&&COHORT&specialty
                RE_&bs._&&COHORT&specialty
                ALL_&bs._&&COHORT&specialty;
quit;


DM 'LOG; CLEAR';
DM 'OUTPUT; CLEAR';


%END;

%if %sysfunc(exist(BSHP&BS._MEDICINE)) AND
    %sysfunc(exist(BSHP&BS._SURGICAL)) AND
    %sysfunc(exist(BSHP&BS._CV)) AND
    %sysfunc(exist(BSHP&BS._CARDIORESPIRATORY)) AND
    %sysfunc(exist(BSHP&BS._NEUROLOGY)) %then %do;


PROC SQL noprint;
CREATE TABLE tin_assigned AS
SELECT DISTINCT tin_assigned,
    COUNT(tin_assigned) AS VOLUME,
    SUM(RADM30) AS READMISSION,
    SUM(RADM30p) AS READM_PLAN
FROM BSHP
GROUP BY tin_assigned;
SELECT MEAN(RADM30) INTO: HWYBAR FROM BSHP;
QUIT;


DATA HWR_RSRR&BS.;
MERGE     tin_assigned (IN=A)
        BSHP&BS._MEDICINE (IN=B KEEP=tin_assigned SRR VOLUME
            RENAME=(SRR=SRR_MED VOLUME=VOLUME_MED))
        BSHP&BS._SURGICAL (IN=C KEEP=tin_assigned SRR VOLUME
            RENAME=(SRR=SRR_SURG VOLUME=VOLUME_SURG))
        BSHP&BS._CV (IN=E KEEP=tin_assigned SRR VOLUME
            RENAME=(SRR=SRR_CV VOLUME=VOLUME_CV))
        BSHP&BS._CARDIORESPIRATORY  (IN=F KEEP=tin_assigned SRR VOLUME
            RENAME=(SRR=SRR_CARDIO VOLUME=VOLUME_CARDIO))
        BSHP&BS._NEUROLOGY (IN=H KEEP=tin_assigned SRR VOLUME
            RENAME=(SRR=SRR_NEURO VOLUME=VOLUME_NEURO));
BY tin_assigned;

IF A;

ITERATION=&BS;

ARRAY RESET0{5}  VOLUME_MED VOLUME_SURG VOLUME_CV VOLUME_CARDIO VOLUME_NEURO;
DO I=1 TO 5;
    IF RESET0(I)=. THEN RESET0(I)=0;
END;


IF VOLUME_MED>0 THEN MED_NUM=VOLUME_MED*LOG(SRR_MED); ELSE MED_NUM=0;
IF VOLUME_SURG>0 THEN SURG_NUM=VOLUME_SURG*LOG(SRR_SURG); ELSE SURG_NUM=0;
IF VOLUME_CV>0 THEN CV_NUM=VOLUME_CV*LOG(SRR_CV); ELSE CV_NUM=0;
IF VOLUME_CARDIO>0 THEN CARDIO_NUM=VOLUME_CARDIO*LOG(SRR_CARDIO); ELSE CARDIO_NUM=0;
IF VOLUME_NEURO>0 THEN NEURO_NUM=VOLUME_NEURO*LOG(SRR_NEURO); ELSE NEURO_NUM=0;

TOTAL_NUM=SUM(MED_NUM,SURG_NUM, CV_NUM, CARDIO_NUM, NEURO_NUM);


TOTAL_NUM=SUM(MED_NUM, SURG_NUM, CV_NUM, CARDIO_NUM, NEURO_NUM);

SRR_HWR=EXP(TOTAL_NUM/VOLUME);
RSRR_HWR=(SRR_HWR*&HWYBAR)*100;
OBS_HWR=(READMISSION/VOLUME)*100;

KEEP  ITERATION tin_assigned SRR_HWR RSRR_HWR OBS_HWR VOLUME READMISSION;

RUN;

PROC APPEND BASE=&TFILE._HWR DATA=HWR_RSRR&BS. FORCE;
RUN;

proc delete data=BSHP&BS._MEDICINE BSHP&BS._SURGICAL BSHP&BS._CV BSHP&BS._CARDIORESPIRATORY BSHP&BS._NEUROLOGY HWR_RSRR&BS.
    bshp h h2 tin_assigned;
quit;


%end;

%END;

%MEND BOOTSTRAP_HOSPITAL_READMISSION;

%macro Post_planned(post=);

    data postindex;
        set &post;
        length   i j k 3.;

***** determine the Proc CCS group each procedure falls into ******;
        ATTRIB procccp_1-procccp_25  LENGTH=$4.;
        ARRAY procccp_ (1:25) procccp_1-procccp_25;
        ARRAY procccsp_(1:25) $  PROC1 - PROC25;

***** ASSIGN PROC CCS TO PROCEDURES  **********;
        DO k=1 TO 25;
            procccp_(k) = put(procccsp_(k),$ccsproc.);
            end;

****** Categorize the CCS Diagnosis Claims for the potential readmissions *******;

 /* PS - adding Array of Diagnoses */
Attrib diag1 - diag25 length=$7.;
Array diag_25(1:25) diag1 - diag25;

DCGDIAG = diag1;
DCGVRS  = CLM_DGNS_PRCDR_ICD_IND; * DVRSND01;
if DCGVRS = "9" then
    /*ADDXG_p = PUT(DCGDIAG,$V9CCS.);*/
    put "ERROR: has ICD9 code";
else
    ADDXG_p = PUT(DCGDIAG,$V0CCS.);


*****THIS SECTION UPDATED WITH FINAL PLANNED ALGORITHM *****************;

***** Create a variable for the AHRQ CCS acute diagnosis based exclusions for planned ****;
***** Some diagnosis groups are split by ICD-9 diagnosis codes                        ****;
** added on 11/2 Version 2.1:
 CCS 129 to acute list, CCS 224 and 170 to planned list , remove diagnosis codes 410.x2
 from acute list CCS 100

REVISED VERSION 3.0: ADD a split for Biliary tract disease  9/2013  add Acute Pancreatitis and HTN w/ Comp
******************************************************************************************;

* PR4 CCS and ICD10: REV 171206;
if ADDXG_p in (/*'1','2','3','4','5','7','8','9','54','55','60','61','63','76','77','78','82'
    ,'83','84','85','87','89','90','91','92','93', '102','104','107','109','112',
    '116','118','120','122','123','99',
    '124','125','126','127','128','129','130','131','135',
    '137','139','140','142','145','146','148',
    '153','154','157','159','165','168','172','197','198','225','226','227','228','229','230',
    '232','233','234','235','237','238','239','240','241','242','243','244','245','246','247',
    '249','250','251','252','253','259','650','651','652','653','656','658','660','661','662','663','670'*/
"1", "2", "3", "4", "5", "7", "8", "9", "54", "55", "60", "61", "63", "76",
    "77", "78", "82", "83", "84", "85", "87", "89", "90", "91", "92", "93",
    "99", "102", "104", "107", "109", "112", "116", "118", "120", "122", "123",
    "124", "125", "126", "127", "128", "129", "130", "131", "135", "137", "139",
    "140", "142", "145", "146", "148", "153", "154", "157", "159", "165", "168",
    "172", "197", "198", "226", "227", "229", "233", "234", "235", "238", "239",
    "240", "241", "242", "243", "244", "245", "246", "247", "249", "250", "251",
    "252", "253", "259", "650", "651", "652", "653", "656", "658", "660", "661",
    "662", "663", "670")

    OR

    (DCGVRS = "9" and
    (( addxg_p in ('105','106') and  diag1
    in ('4260','42610','42611','42612','42613','4262',
    '4263','4264','42650','42651','42652','42653','42654','4266','4267','42681','42682',
    '4269','4272','7850','42789','4279','42769') )
    OR
    (addxg_p in ('97') and  diag1 in
    ('03282','03640','03641','03642','03643','07420','07421','07422','07423',
    '11281','11503','11504','11513','11514','11593','11594',
    '1303','3910','3911','3912','3918','3919','3920','3980',
    '39890','39899','4200','42090','42091','42099','4210','4211',
    '4219','4220','42290','42291','42292','42293','42299','4230',
    '4231','4232','4233','4290'))
    OR
    (addxg_p in ('108') and  diag1 in
    ('39891','4280','4281','42820','42821','42823','42830','42831',
    '42833','42840','42841','42843','4289'))
    OR
    ( addxg_p in ('100') and  (DIAG1=:'410' AND SUBSTR(DIAG1, 5, 1)^='2'))
    OR
    ( addxg_p in ('149') and diag1 in ('5740','57400','57401','5743','57430','57431',
    '5746','57460','57461','5748','57480','57481','5750','57512','5761'))
    OR
    ( addxg_p in ('152') and diag1 in ('5770')) ))

    OR

    (DCGVRS = "0" and diag1 in (
    /*'A3681','A3950','A3953','A3951','A3952','B3320'
    ,'B3323','B3321','B3322','B376','B5881','I010','I011'
    ,'I012','I018','I019','I020','I090','I099','I0989'
    ,'I32','I309','I300','I308','I330','I39','I339','I41'
    ,'I409','I400','I401','I400','I408','I312','I310'
    ,'I311','I314','I514','I442','I4430','I440','I441'
    ,'I4469','I444','I445','I4460','I447','I4510','I4430'
    ,'I4439','I454','I452','I453','I455','I456','I4581'
    ,'I459','I479','R000','I498','R001','I499','I4949'
    ,'I0981','I509','I501','I5020','I5021','I5023'
    ,'I5030','I5031','I5033','I5040','I5041','I5043'
    ,'I509','K8000','K8001','K8042','K8043','K8062'
    ,'K8063','K8066','K8067','K810','K812','K830'
    ,'K859','I301','I450','I4519','I493','I5022'
    ,'I5032','I5042','K8012','K8013','K8046','K8047'
    ,'K8030','K8031','K8032','K8033','K8034','K8035'
    ,'K8036','K8037','B252','K850','K851','K852','K853'
    ,'K858','I2109','I2101','I2102','I2119','I2111'
    ,'I2129','I214','I2121','I213','M3212'*/
    "A3681", "A3950", "A3951", "A3952", "A3953", "B3320", "B3321",
    "B3322", "B3323", "B376", "B5881", "I010", "I011", "I012", "I018",
    "I019", "I020", "I090", "I0989", "I099", "I300", "I301", "I308",
    "I309", "I310", "I311", "I312", "I314", "I32", "I330", "I339",
    "I39", "I400", "I401", "I408", "I409", "I41", "I514", 

    "I2101", "I2102", "I2109", "I2111", "I2119", "I2121", "I2129", "I213",
    "I214", 

    "I440", "I441", "I442", "I4430", "I4439", "I444", "I445", "I4460",
    "I4469", "I447", "I450", "I4510", "I4519", "I452", "I453", "I454",
    "I455", "I456", "I4581", "I459", 

    "I479", "I493", "I4949", "I498", "I499", "R000", "R001", 

    "I0981", "I501", "I5020", "I5021", "I5023", "I5030", "I5031", "I5033",
    "I5040", "I5041", "I5043", "I509", 

    "K55011", "K55012", "K55019", "K55021", "K55022", "K55029", "K55031",
    "K55032", "K55039", "K55041", "K55042", "K55049", "K55051",
    "K55052", "K55059", "K55061", "K55062", "K55069", 

    "I7770", "I7775", "I7776", "I7777", 

    "J852",

    "K8000", "K8001", "K8012", "K8013", "K8030", "K8031", "K8032",
    "K8033", "K8036", "K8037", "K8042", "K8043", "K8046", "K8047",
    "K8062", "K8063", "K8066", "K8067", "K810", "K812", "K830", 

    "K850", "K8500", "K8501", "K8502", "K851", "K8510", "K8511", "K8512",
    "K852", "K8520", "K8521", "K8522", "K853", "K8530", "K8531",
    "K8532", "K858", "K8580", "K8581", "K8582", "K859", "K8590",
    "K8591", "K8592", "K8681", "K8689", 

    "K5530", "K5531", "K5532", "K5533", "K5931",

    "N50811", "N50812", "N50819", "N5082",

    "N610", "N611",

    "N83511", "N83512", "N83519", "N83521", "N83522", "N83529",

    "M1250", "M12511", "M12512", "M12519", "M12521", "M12522", "M12529",
    "M12531", "M12532", "M12539", "M12541", "M12542", "M12549",
    "M12551", "M12552", "M12559", "M12561", "M12562", "M12569",
    "M12571", "M12572", "M12579", "M1258", "M1259", "M2200", "M2201",
    "M2202", "M2210", "M2211", "M2212", "M222X1", "M222X2", "M222X9",
    "M223X1", "M223X2", "M223X9", "M2240", "M2241", "M2242", "M228X1",
    "M228X2", "M228X9", "M2290", "M2291", "M2292", "M23000", "M23001",
    "M23002", "M23003", "M23004", "M23005", "M23006", "M23007",
    "M23009", "M23011", "M23012", "M23019", "M23021", "M23022",
    "M23029", "M23031", "M23032", "M23039", "M23041", "M23042",
    "M23049", "M23051", "M23052", "M23059", "M23061", "M23062",
    "M23069", "M23200", "M23201", "M23202", "M23203", "M23204",
    "M23205", "M23206", "M23207", "M23209", "M23211", "M23212",
    "M23219", "M23221", "M23222", "M23229", "M23231", "M23232",
    "M23239", "M23241", "M23242", "M23249", "M23251", "M23252",
    "M23259", "M23261", "M23262", "M23269", "M23300", "M23301",
    "M23302", "M23303", "M23304", "M23305", "M23306", "M23307",
    "M23309", "M23311", "M23312", "M23319", "M23321", "M23322",
    "M23329", "M23331", "M23332", "M23339", "M23341", "M23342",
    "M23349", "M23351", "M23352", "M23359", "M23361", "M23362",
    "M23369", "M2340", "M2341", "M2342", "M2350", "M2351", "M2352",
    "M23601", "M23602", "M23609", "M23611", "M23612", "M23619",
    "M23621", "M23622", "M23629", "M23631", "M23632", "M23639",
    "M23641", "M23642", "M23649", "M23671", "M23672", "M23679",
    "M238X1", "M238X2", "M238X9", "M2390", "M2391", "M2392", "M2410",
    "M24111", "M24112", "M24119", "M24121", "M24122", "M24129",
    "M24131", "M24132", "M24139", "M24141", "M24142", "M24149",
    "M24151", "M24152", "M24159", "M24171", "M24172", "M24173",
    "M24174", "M24175", "M24176", "M2440", "M24411", "M24412",
    "M24419", "M24421", "M24422", "M24429", "M24431", "M24432",
    "M24439", "M24441", "M24442", "M24443", "M24444", "M24445",
    "M24446", "M24451", "M24452", "M24459", "M24461", "M24462",
    "M24469", "M24471", "M24472", "M24473", "M24474", "M24475",
    "M24476", "M24477", "M24478", "M24479", "M433", "M434", "M435X2",
    "M435X3", "M435X4", "M435X5", "M435X6", "M435X7", "M435X8",
    "M435X9", "M9910", "M9911", "M9912", "M9913", "M9914", "M9915",
    "M9916", "M9917", "M9918", "M9919", "S0300XA", "S0301XA",
    "S0302XA", "S0303XA", "S130XXA", "S13100A", "S13101A", "S13110A",
    "S13111A", "S13120A", "S13121A", "S13130A", "S13131A", "S13140A",
    "S13141A", "S13150A", "S13151A", "S13160A", "S13161A", "S13170A",
    "S13171A", "S13180A", "S13181A", "S1320XA", "S1329XA", "S230XXA",
    "S23100A", "S23101A", "S23110A", "S23111A", "S23120A", "S23121A",
    "S23122A", "S23123A", "S23130A", "S23131A", "S23132A", "S23133A",
    "S23140A", "S23141A", "S23142A", "S23143A", "S23150A", "S23151A",
    "S23152A", "S23153A", "S23160A", "S23161A", "S23162A", "S23163A",
    "S23170A", "S23171A", "S2320XA", "S2329XA", "S330XXA", "S33100A",
    "S33101A", "S33110A", "S33111A", "S33120A", "S33121A", "S33130A",
    "S33131A", "S33140A", "S33141A", "S332XXA", "S3330XA", "S3339XA",
    "S334XXA", "S43001A", "S43002A", "S43003A", "S43004A", "S43005A",
    "S43006A", "S43011A", "S43012A", "S43013A", "S43014A", "S43015A",
    "S43016A", "S43021A", "S43022A", "S43023A", "S43024A", "S43025A",
    "S43026A", "S43031A", "S43032A", "S43033A", "S43034A", "S43035A",
    "S43036A", "S43081A", "S43082A", "S43083A", "S43084A", "S43085A",
    "S43086A", "S43101A", "S43102A", "S43109A", "S43111A", "S43112A",
    "S43119A", "S43121A", "S43122A", "S43129A", "S43131A", "S43132A",
    "S43139A", "S43141A", "S43142A", "S43149A", "S43151A", "S43152A",
    "S43159A", "S43201A", "S43202A", "S43203A", "S43204A", "S43205A",
    "S43206A", "S43211A", "S43212A", "S43213A", "S43214A", "S43215A",
    "S43216A", "S43221A", "S43222A", "S43223A", "S43224A", "S43225A",
    "S43226A", "S43301A", "S43302A", "S43303A", "S43304A", "S43305A",
    "S43306A", "S43311A", "S43312A", "S43313A", "S43314A", "S43315A",
    "S43316A", "S43391A", "S43392A", "S43393A", "S43394A", "S43395A",
    "S43396A", "S53001A", "S53002A", "S53003A", "S53004A", "S53005A",
    "S53006A", "S53011A", "S53012A", "S53013A", "S53014A", "S53015A",
    "S53016A", "S53021A", "S53022A", "S53023A", "S53024A", "S53025A",
    "S53026A", "S53031A", "S53032A", "S53033A", "S53091A", "S53092A",
    "S53093A", "S53094A", "S53095A", "S53096A", "S53101A", "S53102A",
    "S53103A", "S53104A", "S53105A", "S53106A", "S53111A", "S53112A",
    "S53113A", "S53114A", "S53115A", "S53116A", "S53121A", "S53122A",
    "S53123A", "S53124A", "S53125A", "S53126A", "S53131A", "S53132A",
    "S53133A", "S53134A", "S53135A", "S53136A", "S53141A", "S53142A",
    "S53143A", "S53144A", "S53145A", "S53146A", "S53191A", "S53192A",
    "S53193A", "S53194A", "S53195A", "S53196A", "S63001A", "S63002A",
    "S63003A", "S63004A", "S63005A", "S63006A", "S63011A", "S63012A",
    "S63013A", "S63014A", "S63015A", "S63016A", "S63021A", "S63022A",
    "S63023A", "S63024A", "S63025A", "S63026A", "S63031A", "S63032A",
    "S63033A", "S63034A", "S63035A", "S63036A", "S63041A", "S63042A",
    "S63043A", "S63044A", "S63045A", "S63046A", "S63051A", "S63052A",
    "S63053A", "S63054A", "S63055A", "S63056A", "S63061A", "S63062A",
    "S63063A", "S63064A", "S63065A", "S63066A", "S63071A", "S63072A",
    "S63073A", "S63074A", "S63075A", "S63076A", "S63091A", "S63092A",
    "S63093A", "S63094A", "S63095A", "S63096A", "S63101A", "S63102A",
    "S63103A", "S63104A", "S63105A", "S63106A", "S63111A", "S63112A",
    "S63113A", "S63114A", "S63115A", "S63116A", "S63121A", "S63122A",
    "S63123A", "S63124A", "S63125A", "S63126A", "S63131A", "S63132A",
    "S63133A", "S63134A", "S63135A", "S63136A", "S63141A", "S63142A",
    "S63143A", "S63144A", "S63145A", "S63146A", "S63200A", "S63201A",
    "S63202A", "S63203A", "S63204A", "S63205A", "S63206A", "S63207A",
    "S63208A", "S63209A", "S63210A", "S63211A", "S63212A", "S63213A",
    "S63214A", "S63215A", "S63216A", "S63217A", "S63218A", "S63219A",
    "S63220A", "S63221A", "S63222A", "S63223A", "S63224A", "S63225A",
    "S63226A", "S63227A", "S63228A", "S63229A", "S63230A", "S63231A",
    "S63232A", "S63233A", "S63234A", "S63235A", "S63236A", "S63237A",
    "S63238A", "S63239A", "S63240A", "S63241A", "S63242A", "S63243A",
    "S63244A", "S63245A", "S63246A", "S63247A", "S63248A", "S63249A",
    "S63250A", "S63251A", "S63252A", "S63253A", "S63254A", "S63255A",
    "S63256A", "S63257A", "S63258A", "S63259A", "S63260A", "S63261A",
    "S63262A", "S63263A", "S63264A", "S63265A", "S63266A", "S63267A",
    "S63268A", "S63269A", "S63270A", "S63271A", "S63272A", "S63273A",
    "S63274A", "S63275A", "S63276A", "S63277A", "S63278A", "S63279A",
    "S63280A", "S63281A", "S63282A", "S63283A", "S63284A", "S63285A",
    "S63286A", "S63287A", "S63288A", "S63289A", "S63290A", "S63291A",
    "S63292A", "S63293A", "S63294A", "S63295A", "S63296A", "S63297A",
    "S63298A", "S63299A", "S73001A", "S73002A", "S73003A", "S73004A",
    "S73005A", "S73006A", "S73011A", "S73012A", "S73013A", "S73014A",
    "S73015A", "S73016A", "S73021A", "S73022A", "S73023A", "S73024A",
    "S73025A", "S73026A", "S73031A", "S73032A", "S73033A", "S73034A",
    "S73035A", "S73036A", "S73041A", "S73042A", "S73043A", "S73044A",
    "S73045A", "S73046A", "S83001A", "S83002A", "S83003A", "S83004A",
    "S83005A", "S83006A", "S83011A", "S83012A", "S83013A", "S83014A",
    "S83015A", "S83016A", "S83091A", "S83092A", "S83093A", "S83094A",
    "S83095A", "S83096A", "S83101A", "S83102A", "S83103A", "S83104A",
    "S83105A", "S83106A", "S83111A", "S83112A", "S83113A", "S83114A",
    "S83115A", "S83116A", "S83121A", "S83122A", "S83123A", "S83124A",
    "S83125A", "S83126A", "S83131A", "S83132A", "S83133A", "S83134A",
    "S83135A", "S83136A", "S83141A", "S83142A", "S83143A", "S83144A",
    "S83145A", "S83146A", "S83191A", "S83192A", "S83193A", "S83194A",
    "S83195A", "S83196A", "S83200A", "S83201A", "S83202A", "S83203A",
    "S83204A", "S83205A", "S83206A", "S83207A", "S83209A", "S83211A",
    "S83212A", "S83219A", "S83221A", "S83222A", "S83229A", "S83231A",
    "S83232A", "S83239A", "S83241A", "S83242A", "S83249A", "S83251A",
    "S83252A", "S83259A", "S83261A", "S83262A", "S83269A", "S83271A",
    "S83272A", "S83279A", "S83281A", "S83282A", "S83289A", "S8330XA",
    "S8331XA", "S8332XA", "S9301XA", "S9302XA", "S9303XA", "S9304XA",
    "S9305XA", "S9306XA", "S93101A", "S93102A", "S93103A", "S93104A",
    "S93105A", "S93106A", "S93111A", "S93112A", "S93113A", "S93114A",
    "S93115A", "S93116A", "S93119A", "S93121A", "S93122A", "S93123A",
    "S93124A", "S93125A", "S93126A", "S93129A", "S93131A", "S93132A",
    "S93133A", "S93134A", "S93135A", "S93136A", "S93139A", "S93141A",
    "S93142A", "S93143A", "S93144A", "S93145A", "S93146A", "S93149A",
    "S93301A", "S93302A", "S93303A", "S93304A", "S93305A", "S93306A",
    "S93311A", "S93312A", "S93313A", "S93314A", "S93315A", "S93316A",
    "S93321A", "S93322A", "S93323A", "S93324A", "S93325A", "S93326A",
    "S93331A", "S93332A", "S93333A", "S93334A", "S93335A", "S93336A", 

    "S020XXA", "S020XXB", "S02101A", "S02101B", "S02102A", "S02102B",
    "S02109A", "S02109B", "S02110A", "S02110B", "S02111A", "S02111B",
    "S02112A", "S02112B", "S02113A", "S02113B", "S02118A", "S02118B",
    "S02119A", "S02119B", "S0211AA", "S0211AB", "S0211BA", "S0211BB",
    "S0211CA", "S0211CB", "S0211DA", "S0211DB", "S0211EA", "S0211EB",
    "S0211FA", "S0211FB", "S0211GA", "S0211GB", "S0211HA", "S0211HB",
    "S0219XA", "S0219XB", "S022XXA", "S022XXB", "S0230XA", "S0230XB",
    "S0231XA", "S0231XB", "S0232XA", "S0232XB", "S02400A", "S02400B",
    "S02401A", "S02401B", "S02402A", "S02402B", "S0240AA", "S0240AB",
    "S0240BA", "S0240BB", "S0240CA", "S0240CB", "S0240DA", "S0240DB",
    "S0240EA", "S0240EB", "S0240FA", "S0240FB", "S02411A", "S02411B",
    "S02412A", "S02412B", "S02413A", "S02413B", "S0242XA", "S0242XB",
    "S025XXA", "S025XXB", "S02600A", "S02600B", "S02601A", "S02601B",
    "S02602A", "S02602B", "S02609A", "S02609B", "S02610A", "S02610B",
    "S02611A", "S02611B", "S02612A", "S02612B", "S02620A", "S02620B",
    "S02621A", "S02621B", "S02622A", "S02622B", "S02630A", "S02630B",
    "S02631A", "S02631B", "S02632A", "S02632B", "S02640A", "S02640B",
    "S02641A", "S02641B", "S02642A", "S02642B", "S02650A", "S02650B",
    "S02651A", "S02651B", "S02652A", "S02652B", "S0266XA", "S0266XB",
    "S02670A", "S02670B", "S02671A", "S02671B", "S02672A", "S02672B",
    "S0269XA", "S0269XB", "S0280XA", "S0280XB", "S0281XA", "S0281XB",
    "S0282XA", "S0282XB", "S0291XA", "S0291XB", "S0292XA", "S0292XB", 

    "M84361A", "M84362A", "M84363A", "M84364A", "M84369A", "M84371A",
    "M84372A", "M84373A", "M84374A", "M84375A", "M84376A", "M84377A",
    "M84378A", "M84379A", "M84750A", "M84751A", "M84752A", "M84753A",
    "M84754A", "M84755A", "M84756A", "M84757A", "M84758A", "M84759A",
    "S72301A", "S72301B", "S72301C", "S72302A", "S72302B", "S72302C",
    "S72309A", "S72309B", "S72309C", "S72321A", "S72321B", "S72321C",
    "S72322A", "S72322B", "S72322C", "S72323A", "S72323B", "S72323C",
    "S72324A", "S72324B", "S72324C", "S72325A", "S72325B", "S72325C",
    "S72326A", "S72326B", "S72326C", "S72331A", "S72331B", "S72331C",
    "S72332A", "S72332B", "S72332C", "S72333A", "S72333B", "S72333C",
    "S72334A", "S72334B", "S72334C", "S72335A", "S72335B", "S72335C",
    "S72336A", "S72336B", "S72336C", "S72341A", "S72341B", "S72341C",
    "S72342A", "S72342B", "S72342C", "S72343A", "S72343B", "S72343C",
    "S72344A", "S72344B", "S72344C", "S72345A", "S72345B", "S72345C",
    "S72346A", "S72346B", "S72346C", "S72351A", "S72351B", "S72351C",
    "S72352A", "S72352B", "S72352C", "S72353A", "S72353B", "S72353C",
    "S72354A", "S72354B", "S72354C", "S72355A", "S72355B", "S72355C",
    "S72356A", "S72356B", "S72356C", "S72361A", "S72361B", "S72361C",
    "S72362A", "S72362B", "S72362C", "S72363A", "S72363B", "S72363C",
    "S72364A", "S72364B", "S72364C", "S72365A", "S72365B", "S72365C",
    "S72366A", "S72366B", "S72366C", "S72391A", "S72391B", "S72391C",
    "S72392A", "S72392B", "S72392C", "S72399A", "S72399B", "S72399C",
    "S72401A", "S72401B", "S72401C", "S72402A", "S72402B", "S72402C",
    "S72409A", "S72409B", "S72409C", "S72411A", "S72411B", "S72411C",
    "S72412A", "S72412B", "S72412C", "S72413A", "S72413B", "S72413C",
    "S72414A", "S72414B", "S72414C", "S72415A", "S72415B", "S72415C",
    "S72416A", "S72416B", "S72416C", "S72421A", "S72421B", "S72421C",
    "S72422A", "S72422B", "S72422C", "S72423A", "S72423B", "S72423C",
    "S72424A", "S72424B", "S72424C", "S72425A", "S72425B", "S72425C",
    "S72426A", "S72426B", "S72426C", "S72431A", "S72431B", "S72431C",
    "S72432A", "S72432B", "S72432C", "S72433A", "S72433B", "S72433C",
    "S72434A", "S72434B", "S72434C", "S72435A", "S72435B", "S72435C",
    "S72436A", "S72436B", "S72436C", "S72441A", "S72441B", "S72441C",
    "S72442A", "S72442B", "S72442C", "S72443A", "S72443B", "S72443C",
    "S72444A", "S72444B", "S72444C", "S72445A", "S72445B", "S72445C",
    "S72446A", "S72446B", "S72446C", "S72451A", "S72451B", "S72451C",
    "S72452A", "S72452B", "S72452C", "S72453A", "S72453B", "S72453C",
    "S72454A", "S72454B", "S72454C", "S72455A", "S72455B", "S72455C",
    "S72456A", "S72456B", "S72456C", "S72461A", "S72461B", "S72461C",
    "S72462A", "S72462B", "S72462C", "S72463A", "S72463B", "S72463C",
    "S72464A", "S72464B", "S72464C", "S72465A", "S72465B", "S72465C",
    "S72466A", "S72466B", "S72466C", "S72471A", "S72472A", "S72479A",
    "S72491A", "S72491B", "S72491C", "S72492A", "S72492B", "S72492C",
    "S72499A", "S72499B", "S72499C", "S728X1A", "S728X1B", "S728X1C",
    "S728X2A", "S728X2B", "S728X2C", "S728X9A", "S728X9B", "S728X9C",
    "S7290XA", "S7290XB", "S7290XC", "S7291XA", "S7291XB", "S7291XC",
    "S7292XA", "S7292XB", "S7292XC", "S79001A", "S79002A", "S79009A",
    "S79011A", "S79012A", "S79019A", "S79091A", "S79092A", "S79099A",
    "S79101A", "S79102A", "S79109A", "S79111A", "S79112A", "S79119A",
    "S79121A", "S79122A", "S79129A", "S79131A", "S79132A", "S79139A",
    "S79141A", "S79142A", "S79149A", "S79191A", "S79192A", "S79199A",
    "S82001A", "S82001B", "S82001C", "S82002A", "S82002B", "S82002C",
    "S82009A", "S82009B", "S82009C", "S82011A", "S82011B", "S82011C",
    "S82012A", "S82012B", "S82012C", "S82013A", "S82013B", "S82013C",
    "S82014A", "S82014B", "S82014C", "S82015A", "S82015B", "S82015C",
    "S82016A", "S82016B", "S82016C", "S82021A", "S82021B", "S82021C",
    "S82022A", "S82022B", "S82022C", "S82023A", "S82023B", "S82023C",
    "S82024A", "S82024B", "S82024C", "S82025A", "S82025B", "S82025C",
    "S82026A", "S82026B", "S82026C", "S82031A", "S82031B", "S82031C",
    "S82032A", "S82032B", "S82032C", "S82033A", "S82033B", "S82033C",
    "S82034A", "S82034B", "S82034C", "S82035A", "S82035B", "S82035C",
    "S82036A", "S82036B", "S82036C", "S82041A", "S82041B", "S82041C",
    "S82042A", "S82042B", "S82042C", "S82043A", "S82043B", "S82043C",
    "S82044A", "S82044B", "S82044C", "S82045A", "S82045B", "S82045C",
    "S82046A", "S82046B", "S82046C", "S82091A", "S82091B", "S82091C",
    "S82092A", "S82092B", "S82092C", "S82099A", "S82099B", "S82099C",
    "S82101A", "S82101B", "S82101C", "S82102A", "S82102B", "S82102C",
    "S82109A", "S82109B", "S82109C", "S82111A", "S82111B", "S82111C",
    "S82112A", "S82112B", "S82112C", "S82113A", "S82113B", "S82113C",
    "S82114A", "S82114B", "S82114C", "S82115A", "S82115B", "S82115C",
    "S82116A", "S82116B", "S82116C", "S82121A", "S82121B", "S82121C",
    "S82122A", "S82122B", "S82122C", "S82123A", "S82123B", "S82123C",
    "S82124A", "S82124B", "S82124C", "S82125A", "S82125B", "S82125C",
    "S82126A", "S82126B", "S82126C", "S82131A", "S82131B", "S82131C",
    "S82132A", "S82132B", "S82132C", "S82133A", "S82133B", "S82133C",
    "S82134A", "S82134B", "S82134C", "S82135A", "S82135B", "S82135C",
    "S82136A", "S82136B", "S82136C", "S82141A", "S82141B", "S82141C",
    "S82142A", "S82142B", "S82142C", "S82143A", "S82143B", "S82143C",
    "S82144A", "S82144B", "S82144C", "S82145A", "S82145B", "S82145C",
    "S82146A", "S82146B", "S82146C", "S82151A", "S82151B", "S82151C",
    "S82152A", "S82152B", "S82152C", "S82153A", "S82153B", "S82153C",
    "S82154A", "S82154B", "S82154C", "S82155A", "S82155B", "S82155C",
    "S82156A", "S82156B", "S82156C", "S82161A", "S82162A", "S82169A",
    "S82191A", "S82191B", "S82191C", "S82192A", "S82192B", "S82192C",
    "S82199A", "S82199B", "S82199C", "S82201A", "S82201B", "S82201C",
    "S82202A", "S82202B", "S82202C", "S82209A", "S82209B", "S82209C",
    "S82221A", "S82221B", "S82221C", "S82222A", "S82222B", "S82222C",
    "S82223A", "S82223B", "S82223C", "S82224A", "S82224B", "S82224C",
    "S82225A", "S82225B", "S82225C", "S82226A", "S82226B", "S82226C",
    "S82231A", "S82231B", "S82231C", "S82232A", "S82232B", "S82232C",
    "S82233A", "S82233B", "S82233C", "S82234A", "S82234B", "S82234C",
    "S82235A", "S82235B", "S82235C", "S82236A", "S82236B", "S82236C",
    "S82241A", "S82241B", "S82241C", "S82242A", "S82242B", "S82242C",
    "S82243A", "S82243B", "S82243C", "S82244A", "S82244B", "S82244C",
    "S82245A", "S82245B", "S82245C", "S82246A", "S82246B", "S82246C",
    "S82251A", "S82251B", "S82251C", "S82252A", "S82252B", "S82252C",
    "S82253A", "S82253B", "S82253C", "S82254A", "S82254B", "S82254C",
    "S82255A", "S82255B", "S82255C", "S82256A", "S82256B", "S82256C",
    "S82261A", "S82261B", "S82261C", "S82262A", "S82262B", "S82262C",
    "S82263A", "S82263B", "S82263C", "S82264A", "S82264B", "S82264C",
    "S82265A", "S82265B", "S82265C", "S82266A", "S82266B", "S82266C",
    "S82291A", "S82291B", "S82291C", "S82292A", "S82292B", "S82292C",
    "S82299A", "S82299B", "S82299C", "S82301A", "S82301B", "S82301C",
    "S82302A", "S82302B", "S82302C", "S82309A", "S82309B", "S82309C",
    "S82311A", "S82312A", "S82319A", "S82391A", "S82391B", "S82391C",
    "S82392A", "S82392B", "S82392C", "S82399A", "S82399B", "S82399C",
    "S82401A", "S82401B", "S82401C", "S82402A", "S82402B", "S82402C",
    "S82409A", "S82409B", "S82409C", "S82421A", "S82421B", "S82421C",
    "S82422A", "S82422B", "S82422C", "S82423A", "S82423B", "S82423C",
    "S82424A", "S82424B", "S82424C", "S82425A", "S82425B", "S82425C",
    "S82426A", "S82426B", "S82426C", "S82431A", "S82431B", "S82431C",
    "S82432A", "S82432B", "S82432C", "S82433A", "S82433B", "S82433C",
    "S82434A", "S82434B", "S82434C", "S82435A", "S82435B", "S82435C",
    "S82436A", "S82436B", "S82436C", "S82441A", "S82441B", "S82441C",
    "S82442A", "S82442B", "S82442C", "S82443A", "S82443B", "S82443C",
    "S82444A", "S82444B", "S82444C", "S82445A", "S82445B", "S82445C",
    "S82446A", "S82446B", "S82446C", "S82451A", "S82451B", "S82451C",
    "S82452A", "S82452B", "S82452C", "S82453A", "S82453B", "S82453C",
    "S82454A", "S82454B", "S82454C", "S82455A", "S82455B", "S82455C",
    "S82456A", "S82456B", "S82456C", "S82461A", "S82461B", "S82461C",
    "S82462A", "S82462B", "S82462C", "S82463A", "S82463B", "S82463C",
    "S82464A", "S82464B", "S82464C", "S82465A", "S82465B", "S82465C",
    "S82466A", "S82466B", "S82466C", "S82491A", "S82491B", "S82491C",
    "S82492A", "S82492B", "S82492C", "S82499A", "S82499B", "S82499C",
    "S8251XA", "S8251XB", "S8251XC", "S8252XA", "S8252XB", "S8252XC",
    "S8253XA", "S8253XB", "S8253XC", "S8254XA", "S8254XB", "S8254XC",
    "S8255XA", "S8255XB", "S8255XC", "S8256XA", "S8256XB", "S8256XC",
    "S8261XA", "S8261XB", "S8261XC", "S8262XA", "S8262XB", "S8262XC",
    "S8263XA", "S8263XB", "S8263XC", "S8264XA", "S8264XB", "S8264XC",
    "S8265XA", "S8265XB", "S8265XC", "S8266XA", "S8266XB", "S8266XC",
    "S82811A", "S82812A", "S82819A", "S82821A", "S82822A", "S82829A",
    "S82831A", "S82831B", "S82831C", "S82832A", "S82832B", "S82832C",
    "S82839A", "S82839B", "S82839C", "S82841A", "S82841B", "S82841C",
    "S82842A", "S82842B", "S82842C", "S82843A", "S82843B", "S82843C",
    "S82844A", "S82844B", "S82844C", "S82845A", "S82845B", "S82845C",
    "S82846A", "S82846B", "S82846C", "S82851A", "S82851B", "S82851C",
    "S82852A", "S82852B", "S82852C", "S82853A", "S82853B", "S82853C",
    "S82854A", "S82854B", "S82854C", "S82855A", "S82855B", "S82855C",
    "S82856A", "S82856B", "S82856C", "S82861A", "S82861B", "S82861C",
    "S82862A", "S82862B", "S82862C", "S82863A", "S82863B", "S82863C",
    "S82864A", "S82864B", "S82864C", "S82865A", "S82865B", "S82865C",
    "S82866A", "S82866B", "S82866C", "S82871A", "S82871B", "S82871C",
    "S82872A", "S82872B", "S82872C", "S82873A", "S82873B", "S82873C",
    "S82874A", "S82874B", "S82874C", "S82875A", "S82875B", "S82875C",
    "S82876A", "S82876B", "S82876C", "S82891A", "S82891B", "S82891C",
    "S82892A", "S82892B", "S82892C", "S82899A", "S82899B", "S82899C",
    "S8290XA", "S8290XB", "S8290XC", "S8291XA", "S8291XB", "S8291XC",
    "S8292XA", "S8292XB", "S8292XC", "S89001A", "S89002A", "S89009A",
    "S89011A", "S89012A", "S89019A", "S89021A", "S89022A", "S89029A",
    "S89031A", "S89032A", "S89039A", "S89041A", "S89042A", "S89049A",
    "S89091A", "S89092A", "S89099A", "S89101A", "S89102A", "S89109A",
    "S89111A", "S89112A", "S89119A", "S89121A", "S89122A", "S89129A",
    "S89131A", "S89132A", "S89139A", "S89141A", "S89142A", "S89149A",
    "S89191A", "S89192A", "S89199A", "S89201A", "S89202A", "S89209A",
    "S89211A", "S89212A", "S89219A", "S89221A", "S89222A", "S89229A",
    "S89291A", "S89292A", "S89299A", "S89301A", "S89302A", "S89309A",
    "S89311A", "S89312A", "S89319A", "S89321A", "S89322A", "S89329A",
    "S89391A", "S89392A", "S89399A", "S92001A", "S92001B", "S92002A",
    "S92002B", "S92009A", "S92009B", "S92011A", "S92011B", "S92012A",
    "S92012B", "S92013A", "S92013B", "S92014A", "S92014B", "S92015A",
    "S92015B", "S92016A", "S92016B", "S92021A", "S92021B", "S92022A",
    "S92022B", "S92023A", "S92023B", "S92024A", "S92024B", "S92025A",
    "S92025B", "S92026A", "S92026B", "S92031A", "S92031B", "S92032A",
    "S92032B", "S92033A", "S92033B", "S92034A", "S92034B", "S92035A",
    "S92035B", "S92036A", "S92036B", "S92041A", "S92041B", "S92042A",
    "S92042B", "S92043A", "S92043B", "S92044A", "S92044B", "S92045A",
    "S92045B", "S92046A", "S92046B", "S92051A", "S92051B", "S92052A",
    "S92052B", "S92053A", "S92053B", "S92054A", "S92054B", "S92055A",
    "S92055B", "S92056A", "S92056B", "S92061A", "S92061B", "S92062A",
    "S92062B", "S92063A", "S92063B", "S92064A", "S92064B", "S92065A",
    "S92065B", "S92066A", "S92066B", "S92101A", "S92101B", "S92102A",
    "S92102B", "S92109A", "S92109B", "S92111A", "S92111B", "S92112A",
    "S92112B", "S92113A", "S92113B", "S92114A", "S92114B", "S92115A",
    "S92115B", "S92116A", "S92116B", "S92121A", "S92121B", "S92122A",
    "S92122B", "S92123A", "S92123B", "S92124A", "S92124B", "S92125A",
    "S92125B", "S92126A", "S92126B", "S92131A", "S92131B", "S92132A",
    "S92132B", "S92133A", "S92133B", "S92134A", "S92134B", "S92135A",
    "S92135B", "S92136A", "S92136B", "S92141A", "S92141B", "S92142A",
    "S92142B", "S92143A", "S92143B", "S92144A", "S92144B", "S92145A",
    "S92145B", "S92146A", "S92146B", "S92151A", "S92151B", "S92152A",
    "S92152B", "S92153A", "S92153B", "S92154A", "S92154B", "S92155A",
    "S92155B", "S92156A", "S92156B", "S92191A", "S92191B", "S92192A",
    "S92192B", "S92199A", "S92199B", "S92201A", "S92201B", "S92202A",
    "S92202B", "S92209A", "S92209B", "S92211A", "S92211B", "S92212A",
    "S92212B", "S92213A", "S92213B", "S92214A", "S92214B", "S92215A",
    "S92215B", "S92216A", "S92216B", "S92221A", "S92221B", "S92222A",
    "S92222B", "S92223A", "S92223B", "S92224A", "S92224B", "S92225A",
    "S92225B", "S92226A", "S92226B", "S92231A", "S92231B", "S92232A",
    "S92232B", "S92233A", "S92233B", "S92234A", "S92234B", "S92235A",
    "S92235B", "S92236A", "S92236B", "S92241A", "S92241B", "S92242A",
    "S92242B", "S92243A", "S92243B", "S92244A", "S92244B", "S92245A",
    "S92245B", "S92246A", "S92246B", "S92251A", "S92251B", "S92252A",
    "S92252B", "S92253A", "S92253B", "S92254A", "S92254B", "S92255A",
    "S92255B", "S92256A", "S92256B", "S92301A", "S92301B", "S92302A",
    "S92302B", "S92309A", "S92309B", "S92311A", "S92311B", "S92312A",
    "S92312B", "S92313A", "S92313B", "S92314A", "S92314B", "S92315A",
    "S92315B", "S92316A", "S92316B", "S92321A", "S92321B", "S92322A",
    "S92322B", "S92323A", "S92323B", "S92324A", "S92324B", "S92325A",
    "S92325B", "S92326A", "S92326B", "S92331A", "S92331B", "S92332A",
    "S92332B", "S92333A", "S92333B", "S92334A", "S92334B", "S92335A",
    "S92335B", "S92336A", "S92336B", "S92341A", "S92341B", "S92342A",
    "S92342B", "S92343A", "S92343B", "S92344A", "S92344B", "S92345A",
    "S92345B", "S92346A", "S92346B", "S92351A", "S92351B", "S92352A",
    "S92352B", "S92353A", "S92353B", "S92354A", "S92354B", "S92355A",
    "S92355B", "S92356A", "S92356B", "S92401A", "S92401B", "S92402A",
    "S92402B", "S92403A", "S92403B", "S92404A", "S92404B", "S92405A",
    "S92405B", "S92406A", "S92406B", "S92411A", "S92411B", "S92412A",
    "S92412B", "S92413A", "S92413B", "S92414A", "S92414B", "S92415A",
    "S92415B", "S92416A", "S92416B", "S92421A", "S92421B", "S92422A",
    "S92422B", "S92423A", "S92423B", "S92424A", "S92424B", "S92425A",
    "S92425B", "S92426A", "S92426B", "S92491A", "S92491B", "S92492A",
    "S92492B", "S92499A", "S92499B", "S92501A", "S92501B", "S92502A",
    "S92502B", "S92503A", "S92503B", "S92504A", "S92504B", "S92505A",
    "S92505B", "S92506A", "S92506B", "S92511A", "S92511B", "S92512A",
    "S92512B", "S92513A", "S92513B", "S92514A", "S92514B", "S92515A",
    "S92515B", "S92516A", "S92516B", "S92521A", "S92521B", "S92522A",
    "S92522B", "S92523A", "S92523B", "S92524A", "S92524B", "S92525A",
    "S92525B", "S92526A", "S92526B", "S92531A", "S92531B", "S92532A",
    "S92532B", "S92533A", "S92533B", "S92534A", "S92534B", "S92535A",
    "S92535B", "S92536A", "S92536B", "S92591A", "S92591B", "S92592A",
    "S92592B", "S92599A", "S92599B", "S92811A", "S92811B", "S92812A",
    "S92812B", "S92819A", "S92819B", "S92901A", "S92901B", "S92902A",
    "S92902B", "S92909A", "S92909B", "S92911A", "S92911B", "S92912A",
    "S92912B", "S92919A", "S92919B", "S99001A", "S99001B", "S99002A",
    "S99002B", "S99009A", "S99009B", "S99011A", "S99011B", "S99012A",
    "S99012B", "S99019A", "S99019B", "S99021A", "S99021B", "S99022A",
    "S99022B", "S99029A", "S99029B", "S99031A", "S99031B", "S99032A",
    "S99032B", "S99039A", "S99039B", "S99041A", "S99041B", "S99042A",
    "S99042B", "S99049A", "S99049B", "S99091A", "S99091B", "S99092A",
    "S99092B", "S99099A", "S99099B", "S99101A", "S99101B", "S99102A",
    "S99102B", "S99109A", "S99109B", "S99111A", "S99111B", "S99112A",
    "S99112B", "S99119A", "S99119B", "S99121A", "S99121B", "S99122A",
    "S99122B", "S99129A", "S99129B", "S99131A", "S99131B", "S99132A",
    "S99132B", "S99139A", "S99139B", "S99141A", "S99141B", "S99142A",
    "S99142B", "S99149A", "S99149B", "S99191A", "S99191B", "S99192A",
    "S99192B", "S99199A", "S99199B", "S99201A", "S99201B", "S99202A",
    "S99202B", "S99209A", "S99209B", "S99211A", "S99211B", "S99212A",
    "S99212B", "S99219A", "S99219B", "S99221A", "S99221B", "S99222A",
    "S99222B", "S99229A", "S99229B", "S99231A", "S99231B", "S99232A",
    "S99232B", "S99239A", "S99239B", "S99241A", "S99241B", "S99242A",
    "S99242B", "S99249A", "S99249B", "S99291A", "S99291B", "S99292A",
    "S99292B", "S99299A", "S99299B", 

    "S031XXA", "S0340XA", "S0341XA", "S0342XA", "S0343XA", "S038XXA",
    "S039XXA", "S0911XA", "S134XXA", "S135XXA", "S138XXA", "S139XXA",
    "S161XXA", "S233XXA", "S2341XA", "S23420A", "S23421A", "S23428A",
    "S23429A", "S238XXA", "S239XXA", "S29011A", "S29012A", "S29019A",
    "S335XXA", "S336XXA", "S338XXA", "S339XXA", "S39011A", "S39012A",
    "S39013A", "S43401A", "S43402A", "S43409A", "S43411A", "S43412A",
    "S43419A", "S43421A", "S43422A", "S43429A", "S43431A", "S43432A",
    "S43439A", "S43491A", "S43492A", "S43499A", "S4350XA", "S4351XA",
    "S4352XA", "S4360XA", "S4361XA", "S4362XA", "S4380XA", "S4381XA",
    "S4382XA", "S4390XA", "S4391XA", "S4392XA", "S46011A", "S46012A",
    "S46019A", "S46111A", "S46112A", "S46119A", "S46211A", "S46212A",
    "S46219A", "S46311A", "S46312A", "S46319A", "S46811A", "S46812A",
    "S46819A", "S46911A", "S46912A", "S46919A", "S5320XA", "S5321XA",
    "S5322XA", "S5330XA", "S5331XA", "S5332XA", "S53401A", "S53402A",
    "S53409A", "S53411A", "S53412A", "S53419A", "S53421A", "S53422A",
    "S53429A", "S53431A", "S53432A", "S53439A", "S53441A", "S53442A",
    "S53449A", "S53491A", "S53492A", "S53499A", "S56011A", "S56012A",
    "S56019A", "S56111A", "S56112A", "S56113A", "S56114A", "S56115A",
    "S56116A", "S56117A", "S56118A", "S56119A", "S56211A", "S56212A",
    "S56219A", "S56311A", "S56312A", "S56319A", "S56411A", "S56412A",
    "S56413A", "S56414A", "S56415A", "S56416A", "S56417A", "S56418A",
    "S56419A", "S56511A", "S56512A", "S56519A", "S56811A", "S56812A",
    "S56819A", "S56911A", "S56912A", "S56919A", "S63301A", "S63302A",
    "S63309A", "S63311A", "S63312A", "S63319A", "S63321A", "S63322A",
    "S63329A", "S63331A", "S63332A", "S63339A", "S63391A", "S63392A",
    "S63399A", "S63400A", "S63401A", "S63402A", "S63403A", "S63404A",
    "S63405A", "S63406A", "S63407A", "S63408A", "S63409A", "S63410A",
    "S63411A", "S63412A", "S63413A", "S63414A", "S63415A", "S63416A",
    "S63417A", "S63418A", "S63419A", "S63420A", "S63421A", "S63422A",
    "S63423A", "S63424A", "S63425A", "S63426A", "S63427A", "S63428A",
    "S63429A", "S63430A", "S63431A", "S63432A", "S63433A", "S63434A",
    "S63435A", "S63436A", "S63437A", "S63438A", "S63439A", "S63490A",
    "S63491A", "S63492A", "S63493A", "S63494A", "S63495A", "S63496A",
    "S63497A", "S63498A", "S63499A", "S63501A", "S63502A", "S63509A",
    "S63511A", "S63512A", "S63519A", "S63521A", "S63522A", "S63529A",
    "S63591A", "S63592A", "S63599A", "S63601A", "S63602A", "S63609A",
    "S63610A", "S63611A", "S63612A", "S63613A", "S63614A", "S63615A",
    "S63616A", "S63617A", "S63618A", "S63619A", "S63621A", "S63622A",
    "S63629A", "S63630A", "S63631A", "S63632A", "S63633A", "S63634A",
    "S63635A", "S63636A", "S63637A", "S63638A", "S63639A", "S63641A",
    "S63642A", "S63649A", "S63650A", "S63651A", "S63652A", "S63653A",
    "S63654A", "S63655A", "S63656A", "S63657A", "S63658A", "S63659A",
    "S63681A", "S63682A", "S63689A", "S63690A", "S63691A", "S63692A",
    "S63693A", "S63694A", "S63695A", "S63696A", "S63697A", "S63698A",
    "S63699A", "S638X1A", "S638X2A", "S638X9A", "S6390XA", "S6391XA",
    "S6392XA", "S66011A", "S66012A", "S66019A", "S66110A", "S66111A",
    "S66112A", "S66113A", "S66114A", "S66115A", "S66116A", "S66117A",
    "S66118A", "S66119A", "S66211A", "S66212A", "S66219A", "S66310A",
    "S66311A", "S66312A", "S66313A", "S66314A", "S66315A", "S66316A",
    "S66317A", "S66318A", "S66319A", "S66411A", "S66412A", "S66419A",
    "S66510A", "S66511A", "S66512A", "S66513A", "S66514A", "S66515A",
    "S66516A", "S66517A", "S66518A", "S66519A", "S66811A", "S66812A",
    "S66819A", "S66911A", "S66912A", "S66919A", "S73101A", "S73102A",
    "S73109A", "S73111A", "S73112A", "S73119A", "S73121A", "S73122A",
    "S73129A", "S73191A", "S73192A", "S73199A", "S76011A", "S76012A",
    "S76019A", "S76111A", "S76112A", "S76119A", "S76211A", "S76212A",
    "S76219A", "S76311A", "S76312A", "S76319A", "S76811A", "S76812A",
    "S76819A", "S76911A", "S76912A", "S76919A", "S83401A", "S83402A",
    "S83409A", "S83411A", "S83412A", "S83419A", "S83421A", "S83422A",
    "S83429A", "S83501A", "S83502A", "S83509A", "S83511A", "S83512A",
    "S83519A", "S83521A", "S83522A", "S83529A", "S8360XA", "S8361XA",
    "S8362XA", "S838X1A", "S838X2A", "S838X9A", "S8390XA", "S8391XA",
    "S8392XA", "S86011A", "S86012A", "S86019A", "S86111A", "S86112A",
    "S86119A", "S86211A", "S86212A", "S86219A", "S86311A", "S86312A",
    "S86319A", "S86811A", "S86812A", "S86819A", "S86911A", "S86912A",
    "S86919A", "S93401A", "S93402A", "S93409A", "S93411A", "S93412A",
    "S93419A", "S93421A", "S93422A", "S93429A", "S93431A", "S93432A",
    "S93439A", "S93491A", "S93492A", "S93499A", "S93501A", "S93502A",
    "S93503A", "S93504A", "S93505A", "S93506A", "S93509A", "S93511A",
    "S93512A", "S93513A", "S93514A", "S93515A", "S93516A", "S93519A",
    "S93521A", "S93522A", "S93523A", "S93524A", "S93525A", "S93526A",
    "S93529A", "S93601A", "S93602A", "S93609A", "S93611A", "S93612A",
    "S93619A", "S93621A", "S93622A", "S93629A", "S93691A", "S93692A",
    "S93699A", "S96011A", "S96012A", "S96019A", "S96111A", "S96112A",
    "S96119A", "S96211A", "S96212A", "S96219A", "S96811A", "S96812A",
    "S96819A", "S96911A", "S96912A", "S96919A", 

    "D89810", "D89811", "D89812", "D89813", "I25700", "I25701", "I25708",
    "I25709", "I25710", "I25711", "I25718", "I25719", "I25720", "I25721",
    "I25728", "I25729", "I25730", "I25731", "I25738", "I25739", "I25760",
    "I25761", "I25768", "I25769", "I25790", "I25791", "I25798", "I25799",
    "I25810", "I25812", "I70301", "I70302", "I70303", "I70308", "I70309",
    "I70311", "I70312", "I70313", "I70318", "I70319", "I70321", "I70322",
    "I70323", "I70328", "I70329", "I70331", "I70332", "I70333", "I70334",
    "I70335", "I70338", "I70339", "I70341", "I70342", "I70343", "I70344",
    "I70345", "I70348", "I70349", "I7035", "I70361", "I70362", "I70363",
    "I70368", "I70369", "I70391", "I70392", "I70393", "I70398", "I70399",
    "I70401", "I70402", "I70403", "I70408", "I70409", "I70411", "I70412",
    "I70413", "I70418", "I70419", "I70421", "I70422", "I70423", "I70428",
    "I70429", "I70431", "I70432", "I70433", "I70434", "I70435", "I70438",
    "I70439", "I70441", "I70442", "I70443", "I70444", "I70445", "I70448",
    "I70449", "I7045", "I70461", "I70462", "I70463", "I70468", "I70469",
    "I70491", "I70492", "I70493", "I70498", "I70499", "I70501", "I70502",
    "I70503", "I70508", "I70509", "I70511", "I70512", "I70513", "I70518",
    "I70519", "I70521", "I70522", "I70523", "I70528", "I70529", "I70531",
    "I70532", "I70533", "I70534", "I70535", "I70538", "I70539", "I70541",
    "I70542", "I70543", "I70544", "I70545", "I70548", "I70549", "I7055",
    "I70561", "I70562", "I70563", "I70568", "I70569", "I70591", "I70592",
    "I70593", "I70598", "I70599", "I70601", "I70602", "I70603", "I70608",
    "I70609", "I70611", "I70612", "I70613", "I70618", "I70619", "I70621",
    "I70622", "I70623", "I70628", "I70629", "I70631", "I70632", "I70633",
    "I70634", "I70635", "I70638", "I70639", "I70641", "I70642", "I70643",
    "I70644", "I70645", "I70648", "I70649", "I7065", "I70661", "I70662",
    "I70663", "I70668", "I70669", "I70691", "I70692", "I70693", "I70698",
    "I70699", "I70701", "I70702", "I70703", "I70708", "I70709", "I70711",
    "I70712", "I70713", "I70718", "I70719", "I70721", "I70722", "I70723",
    "I70728", "I70729", "I70731", "I70732", "I70733", "I70734", "I70735",
    "I70738", "I70739", "I70741", "I70742", "I70743", "I70744", "I70745",
    "I70748", "I70749", "I7075", "I70761", "I70762", "I70763", "I70768",
    "I70769", "I70791", "I70792", "I70793", "I70798", "I70799", "K9400",
    "K9401", "K9402", "K9409", "K9410", "K9411", "K9412", "K9419",
    "M96621", "M96622", "M96629", "M96631", "M96632", "M96639", "M9665",
    "M96661", "M96662", "M96669", "M96671", "M96672", "M96679", "M9669",
    "S343XXA", "T8201XA", "T8202XA", "T8203XA", "T8209XA", "T82110A",
    "T82111A", "T82118A", "T82119A", "T82120A", "T82121A", "T82128A",
    "T82129A", "T82190A", "T82191A", "T82198A", "T82199A", "T82211A",
    "T82212A", "T82213A", "T82218A", "T82221A", "T82222A", "T82223A",
    "T82228A", "T82310A", "T82311A", "T82312A", "T82318A", "T82319A",
    "T82320A", "T82321A", "T82322A", "T82328A", "T82329A", "T82330A",
    "T82331A", "T82332A", "T82338A", "T82339A", "T82390A", "T82391A",
    "T82392A", "T82398A", "T82399A", "T8241XA", "T8242XA", "T8243XA",
    "T8249XA", "T82510A", "T82511A", "T82512A", "T82513A", "T82514A",
    "T82515A", "T82518A", "T82519A", "T82520A", "T82521A", "T82522A",
    "T82523A", "T82524A", "T82525A", "T82528A", "T82529A", "T82530A",
    "T82531A", "T82532A", "T82533A", "T82534A", "T82535A", "T82538A",
    "T82539A", "T82590A", "T82591A", "T82592A", "T82593A", "T82594A",
    "T82595A", "T82598A", "T82599A", "T826XXA", "T827XXA", "T82817A",
    "T82818A", "T82827A", "T82828A", "T82837A", "T82838A", "T82847A",
    "T82848A", "T82855A", "T82856A", "T82857A", "T82858A", "T82867A",
    "T82868A", "T82897A", "T82898A", "T829XXA", "T83010A", "T83011A",
    "T83012A", "T83018A", "T83020A", "T83021A", "T83022A", "T83028A",
    "T83030A", "T83031A", "T83032A", "T83038A", "T83090A", "T83091A",
    "T83092A", "T83098A", "T83110A", "T83111A", "T83112A", "T83113A",
    "T83118A", "T83120A", "T83121A", "T83122A", "T83123A", "T83128A",
    "T83190A", "T83191A", "T83192A", "T83193A", "T83198A", "T8321XA",
    "T8322XA", "T8323XA", "T8324XA", "T8325XA", "T8329XA", "T8331XA",
    "T8332XA", "T8339XA", "T83410A", "T83411A", "T83418A", "T83420A",
    "T83421A", "T83428A", "T83490A", "T83491A", "T83498A", "T83510A",
    "T83511A", "T83512A", "T83518A", "T83590A", "T83591A", "T83592A",
    "T83593A", "T83598A", "T8361XA", "T8362XA", "T8369XA", "T83711A",
    "T83712A", "T83713A", "T83714A", "T83718A", "T83719A", "T83721A",
    "T83722A", "T83723A", "T83724A", "T83728A", "T83729A", "T8379XA",
    "T8381XA", "T8382XA", "T8383XA", "T8384XA", "T8385XA", "T8386XA",
    "T8389XA", "T839XXA", "T84010A", "T84011A", "T84012A", "T84013A",
    "T84018A", "T84019A", "T84020A", "T84021A", "T84022A", "T84023A",
    "T84028A", "T84029A", "T84030A", "T84031A", "T84032A", "T84033A",
    "T84038A", "T84039A", "T84040A", "T84041A", "T84042A", "T84043A",
    "T84048A", "T84049A", "T84050A", "T84051A", "T84052A", "T84053A",
    "T84058A", "T84059A", "T84060A", "T84061A", "T84062A", "T84063A",
    "T84068A", "T84069A", "T84090A", "T84091A", "T84092A", "T84093A",
    "T84098A", "T84099A", "T84110A", "T84111A", "T84112A", "T84113A",
    "T84114A", "T84115A", "T84116A", "T84117A", "T84119A", "T84120A",
    "T84121A", "T84122A", "T84123A", "T84124A", "T84125A", "T84126A",
    "T84127A", "T84129A", "T84190A", "T84191A", "T84192A", "T84193A",
    "T84194A", "T84195A", "T84196A", "T84197A", "T84199A", "T84210A",
    "T84213A", "T84216A", "T84218A", "T84220A", "T84223A", "T84226A",
    "T84228A", "T84290A", "T84293A", "T84296A", "T84298A", "T84310A",
    "T84318A", "T84320A", "T84328A", "T84390A", "T84398A", "T84410A",
    "T84418A", "T84420A", "T84428A", "T84490A", "T84498A", "T8450XA",
    "T8451XA", "T8452XA", "T8453XA", "T8454XA", "T8459XA", "T8460XA",
    "T84610A", "T84611A", "T84612A", "T84613A", "T84614A", "T84615A",
    "T84619A", "T84620A", "T84621A", "T84622A", "T84623A", "T84624A",
    "T84625A", "T84629A", "T8463XA", "T8469XA", "T847XXA", "T8481XA",
    "T8482XA", "T8483XA", "T8484XA", "T8485XA", "T8486XA", "T8489XA",
    "T849XXA", "T8501XA", "T8502XA", "T8503XA", "T8509XA", "T85110A",
    "T85111A", "T85112A", "T85113A", "T85118A", "T85120A", "T85121A",
    "T85122A", "T85123A", "T85128A", "T85190A", "T85191A", "T85192A",
    "T85193A", "T85199A", "T8521XA", "T8522XA", "T8529XA", "T85310A",
    "T85311A", "T85318A", "T85320A", "T85321A", "T85328A", "T85390A",
    "T85391A", "T85398A", "T8541XA", "T8542XA", "T8543XA", "T8544XA",
    "T8549XA", "T85510A", "T85511A", "T85518A", "T85520A", "T85521A",
    "T85528A", "T85590A", "T85591A", "T85598A", "T85610A", "T85611A",
    "T85612A", "T85613A", "T85614A", "T85615A", "T85618A", "T85620A",
    "T85621A", "T85622A", "T85623A", "T85624A", "T85625A", "T85628A",
    "T85630A", "T85631A", "T85633A", "T85635A", "T85638A", "T85690A",
    "T85691A", "T85692A", "T85693A", "T85694A", "T85695A", "T85698A",
    "T8571XA", "T8572XA", "T85730A", "T85731A", "T85732A", "T85733A",
    "T85734A", "T85735A", "T85738A", "T8579XA", "T85810A", "T85818A",
    "T85820A", "T85828A", "T85830A", "T85838A", "T85840A", "T85848A",
    "T85850A", "T85858A", "T85860A", "T85868A", "T85890A", "T85898A",
    "T859XXA", "T8600", "T8601", "T8602", "T8603", "T8609", "T8610",
    "T8611", "T8612", "T8613", "T8619", "T8620", "T8621", "T8622",
    "T8623", "T86290", "T86298", "T8630", "T8631", "T8632", "T8633",
    "T8639", "T8640", "T8641", "T8642", "T8643", "T8649", "T865",
    "T86810", "T86811", "T86812", "T86818", "T86819", "T86820", "T86821",
    "T86822", "T86828", "T86829", "T86830", "T86831", "T86832", "T86838",
    "T86839", "T86840", "T86841", "T86842", "T86848", "T86849", "T86850",
    "T86851", "T86852", "T86858", "T86859", "T86890", "T86891", "T86892",
    "T86898", "T86899", "T8690", "T8691", "T8692", "T8693", "T8699",
    "T870X1", "T870X2", "T870X9", "T871X1", "T871X2", "T871X9", "T872" 
    )) /*added M3212 per Amy Mills email 3/9/2017*/
    then excldx = 1; else excldx = 0;

/* PS - cluster codes */
*    if DCGVRS = "0" and diag1 in ('B394','B395','B399') then do I=2 to 25;
*        if diag_25(I) IN ('I39','I32') then excldx = 1;
*        End;


*******************************************************************************;
    ARRAY PROCCS(25) $  PROCCCP_1 - PROCCCP_25;
    ARRAY pproc(25) $   PROC1 -  PROC25;
*    ARRAY ppvsncd(25) $ PVSNCD01 - PVSNCD25;
    planned_1 = 0; planned_2=0;

****CREATE ALWAYS PLANNED PROCEDURE VARIABLE*******;
    DO I=1 TO 25;
        * PR1: REV 171206;
        IF proccs(I) IN
            ('64','105','176' /*,'134','135'*/)THEN do;
            proc_2  = proccs(I);
            planned_2 = 1;
            end;
        end;

***Determine if Planned Procedure Occurred:  Version 3.0 REVISED SEP 2013****
REMOVE 211 and 224 per valdiation results  ****;
    DO I=1 TO 25;
        * PR3 CCS: REV 171206, NOTE: 175 is for ICD10 only;
        IF proccs(I) IN
            (/*'3','5','9','10','12','33','36','38','40','43','44','45','47','48','49',
            '51','52','53','55','56','59','62','66','67','74','78','79','84',
            '85','86','99','104','106','107','109','112','113','114','119','120',
            '124','129','132','142','152','153','154','157','158','159',
            '166','167','172'*/
            "1", "3", "5", "9", "10", "12", "33", "36", "38", "40", "43", "44",
            "45", "49", "51", "52", "53", "55", "56", "59", "66", "67", "74",
            "78", "79", "84", "85", "86", "99", "104", "106", "107", "109",
            "112", "113", "114", "119", "120", "124", "129", "132", "142",
            "152", "153", "154", "158", "159", "166", "167", "172")
            OR (CLM_DGNS_PRCDR_ICD_IND = '9' AND proccs(I) IN ('169','170'))
            OR (CLM_DGNS_PRCDR_ICD_IND = '0' AND proccs(I) = '175') THEN do;
            procnum  = proccs(I);
            planned_1 = 1;
            end;
        end;
**********ADD ICD_CM Proc code level Planned Procedures *****;

    DO J=1 TO 25;
        if CLM_DGNS_PRCDR_ICD_IND ="9" and
            pproc(J) in ('9426','9427') then do;
            procnum  = '990';
            planned_1 = 1;
            end;

        if  CLM_DGNS_PRCDR_ICD_IND ="9" and
            pproc(J) in ('304','3174','346','301','3029','303') then do;
            procnum  = '991';
            planned_1 = 1;
            end;
        if  CLM_DGNS_PRCDR_ICD_IND ="9" and
            pproc(J) in ('5503','5504') then do;
            procnum  = '992';
            planned_1 = 1;
            end;
        if  CLM_DGNS_PRCDR_ICD_IND ="9" and
            pproc(J) in ('3818') then do;
            procnum  = '993';
            planned_1 = 1;
            end;
/* if version ICD 10 */
            * PR3 potentially planned procedures: REV 171206;
            if  CLM_DGNS_PRCDR_ICD_IND ="0" and
                pproc(J) in (/*'0CBS0ZZ','0CBS3ZZ','0CBS4ZZ','0CBS7ZZ','0CBS8ZZ'
                ,'0CBS0ZZ','0CBS3ZZ','0CBS4ZZ','0CBS7ZZ','0CBS8ZZ'
                ,'0B110F4','0B110Z4','0B113F4','0B113Z4','0B114F4'
                ,'0B114Z4','0CTS0ZZ','0CTS4ZZ','0CTS7ZZ','0CTS8ZZ'
                ,'0B110F4','0B110Z4','0B113F4','0B113Z4','0B114F4'
                ,'0B114Z4','0CTS0ZZ','0CTS4ZZ','0CTS7ZZ','0CTS8ZZ'
                ,'0GTG0ZZ','0GTG4ZZ','0GTH0ZZ','0GTH4ZZ','0GTK0ZZ'
                ,'0GTK4ZZ','0WB60ZZ','0WB63ZZ','0WB64ZZ','0WB6XZZ'
                ,'0BW10FZ','0BW13FZ','0BW14FZ','0WB6XZ2','0WQ6XZ2'
                ,'0B5N0ZZ','0B5N3ZZ','0B5N4ZZ','0B5P0ZZ','0B5P3ZZ'
                ,'0B5P4ZZ','04CK0ZZ','04CK3ZZ','04CK4ZZ','04CL0ZZ'
                ,'04CL3ZZ','04CL4ZZ','04CM0ZZ','04CM3ZZ','04CM4ZZ'
                ,'04CN0ZZ','04CN3ZZ','04CN4ZZ','04CP0ZZ','04CP3ZZ'
                ,'04CP4ZZ','04CQ0ZZ','04CQ3ZZ','04CQ4ZZ','04CR0ZZ'
                ,'04CR3ZZ','04CR4ZZ','04CS0ZZ','04CS3ZZ','04CS4ZZ'
                ,'04CT0ZZ','04CT3ZZ','04CT4ZZ','04CU0ZZ','04CU3ZZ'
                ,'04CU4ZZ','04CV0ZZ','04CV3ZZ','04CV4ZZ','04CW0ZZ'
                ,'04CW3ZZ','04CW4ZZ','04CY0ZZ','04CY3ZZ','04CY4ZZ'
                ,'0T9030Z','0T9040Z','0T9130Z','0T9140Z','0TC03ZZ'
                ,'0TC04ZZ','0TC13ZZ','0TC14ZZ','0TF33ZZ','0TF34ZZ'
                ,'0TF43ZZ','0TF44ZZ','GZB4ZZZ','0TC33ZZ','0TC34ZZ'
                ,'0TC43ZZ','0TC44ZZ','GZB0ZZZ','GZB1ZZZ','GZB2ZZZ'
                ,'GZB3ZZZ','07T10ZZ','07T14ZZ','07T20ZZ','07T24ZZ'*/
                
                "0TC03ZZ", "0TC04ZZ", "0TC13ZZ", "0TC14ZZ", "0TC33ZZ",
                "0TC34ZZ", "0TC43ZZ", "0TC44ZZ",

                "0T9030Z", "0T9130Z",

                "0W4M070", "0W4M0J0", "0W4M0K0", "0W4M0Z0",

                "0QP404Z", "0QP434Z", "0QP444Z", "0QP504Z", "0QP534Z",
                "0QP544Z", "0QP604Z", "0QP634Z", "0QP644Z", "0QP704Z",
                "0QP734Z", "0QP744Z", "0QP804Z", "0QP834Z", "0QP844Z",
                "0QP904Z", "0QP934Z", "0QP944Z", "0QPB04Z", "0QPB34Z",
                "0QPB44Z", "0QPC04Z", "0QPC34Z", "0QPC44Z",

                "GZB0ZZZ", "GZB1ZZZ", "GZB2ZZZ", "GZB3ZZZ", "GZB4ZZZ",
                "0CBS4ZZ", "0CBS7ZZ", "0CBS8ZZ",

                "0B5N0ZZ", "0B5N3ZZ", "0B5N4ZZ", "0B5P0ZZ", "0B5P3ZZ",
                "0B5P4ZZ", "0BW10FZ", "0BW13FZ", "0BW14FZ",

                "0TN00ZZ", "0TN03ZZ", "0TN04ZZ", "0TN10ZZ", "0TN13ZZ",
                "0TN14ZZ", "0TN30ZZ", "0TN33ZZ", "0TN34ZZ", "0TN40ZZ",
                "0TN43ZZ", "0TN44ZZ", "0TN60ZZ", "0TN63ZZ", "0TN64ZZ",
                "0TN70ZZ", "0TN73ZZ", "0TN74ZZ"
                )
                then do;
                procnum  = proccs(J);
                planned_1 = 1;
                end;
            END;

        planned = 0;

/*step1: Always Planned Procedures*/
        if planned_2 = 1 then do; planned = 1; procnum = proc_2;
            end;

/*step2: Always Planned Diagnoses*/ ****** Maintenance Chemo Therapy  ******;  ****** Rehabilitation Therapy  ******;
    else if ADDXG_p = '45' then do;
        planned = 1;   procnum = '999' ;
        end;
    else if ADDXG_p = '254' then do;
        planned = 1;    procnum = '998' ;
        end;
    * PR2: REV 171206;
    /*
    else if ADDXG_p = '194' then do;
        planned = 1;   procnum = '997' ;
        end;
    else if ADDXG_p = '196' then do;
        planned = 1;   procnum = '996' ;
        end;
    */
 ****** Forcep Delivery  ******;   ****** Normal Delivery  ******;
/*step3: All Other Planned */
 else if planned_1 =1 and excldx = 1 then planned = 0;
 else if planned_1 =1  and excldx = 0 then planned = 1;
    run;
    %mend Post_planned;
